/*
 * Decompiled with CFR 0.152.
 */
package org.javax.csv.csvio.impl;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.javax.csv.csvio.GenericCsvReader;
import org.javax.csv.csvio.GenericCsvReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvReaderImpl
extends GenericCsvReader {
    private SeparatorSet separatorSet;
    private char[] buffer;
    private int buffer_size;
    private boolean eof;
    private StringBuilder builder;
    private int block_size;
    private int value_start;
    private int block_index;
    private int expectedColumnCount;

    public CsvReaderImpl(Properties properties, Reader reader) {
        super(properties, reader);
        this.separatorSet = new SeparatorSet(properties);
        this.buffer_size = Integer.parseInt(properties.getProperty("BufferSize", "4096"));
        this.buffer = new char[this.buffer_size];
        this.builder = new StringBuilder();
        this.expectedColumnCount = 10;
    }

    @Override
    public List<String> read() throws IOException {
        if (this.block_size == 0) {
            this.readBlock();
        }
        if (this.eof) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(this.expectedColumnCount);
        Mode mode = Mode.VALUE;
        boolean separator_id = false;
        int separator_offset = 0;
        int value_end = -1;
        boolean eol = false;
        block0: while (!eol) {
            while (this.block_index < this.block_size) {
                char c = this.buffer[this.block_index];
                if (mode == Mode.SEPERATOR && !this.separatorSet.getCurrent().matches(c, ++separator_offset) && !this.separatorSet.nextCurrent(separator_offset - 1)) {
                    mode = Mode.VALUE;
                }
                if (mode == Mode.VALUE && this.separatorSet.matchStart(c)) {
                    mode = Mode.SEPERATOR;
                    separator_offset = 0;
                    value_end = this.block_index;
                }
                if (mode == Mode.SEPERATOR && this.separatorSet.getCurrent().isExceeded(separator_offset)) {
                    if (this.separatorSet.getCurrent().isRecordSeparator()) {
                        eol = true;
                    }
                    mode = Mode.STORE;
                }
                if (mode == Mode.STORE) {
                    this.builder.append(this.buffer, this.value_start, value_end - this.value_start);
                    result.add(this.builder.toString());
                    this.builder.delete(0, this.builder.length());
                    this.value_start = this.block_index + 1;
                    value_end = -1;
                    mode = Mode.VALUE;
                }
                ++this.block_index;
                if (!eol) continue;
                break block0;
            }
            if (mode == Mode.VALUE) {
                this.builder.append(this.buffer, this.value_start, this.block_index - this.value_start);
            } else {
                this.builder.append(this.buffer, this.value_start, value_end - this.value_start);
            }
            this.readBlock();
            value_end = 0;
            if (this.block_size != -1) continue;
            eol = true;
            result.add(this.builder.toString());
        }
        this.expectedColumnCount = result.size();
        return result;
    }

    @Override
    public void close() throws IOException {
        super.getReader().close();
    }

    private void readBlock() throws IOException {
        this.block_size = super.getReader().read(this.buffer, 0, this.buffer_size);
        if (this.block_size == -1) {
            this.eof = true;
        }
        this.block_index = 0;
        this.value_start = 0;
    }

    private class RecordSeparator
    extends Separator {
        public RecordSeparator(String string) {
            super(string, true);
        }
    }

    private class FieldSeparator
    extends Separator {
        public FieldSeparator(String string) {
            super(string, false);
        }
    }

    private abstract class Separator {
        private char[] characters;
        private boolean isRecordSeparator;

        protected Separator(String string, boolean isRecordSeparator) {
            this.characters = string.toCharArray();
            this.isRecordSeparator = isRecordSeparator;
        }

        public final boolean isRecordSeparator() {
            return this.isRecordSeparator;
        }

        public final int getLength() {
            return this.characters.length;
        }

        public final boolean matches(char character, int index) {
            return this.characters[index] == character;
        }

        public final boolean startsWith(char character) {
            return this.characters[0] == character;
        }

        public final boolean matchesAt(Separator separator, int index) {
            return this.characters[index] == separator.characters[index];
        }

        public boolean isExceeded(int length) {
            return length >= this.characters.length - 1;
        }

        public String toString() {
            return String.format("[%s %s]", this.isRecordSeparator ? "R" : "F", String.valueOf(this.characters));
        }
    }

    private class SeparatorSet {
        private Separator[] separators;
        private int[][] nextSeparators;
        private int current;

        public SeparatorSet(Properties properties) {
            String propertySplitString = properties.getProperty("PropertyValueSeparator", " ");
            String fieldSeparators = properties.getProperty("FieldSeparator");
            String recordSeparators = properties.getProperty("RecordSeparator");
            this.evaluateSeparators(propertySplitString, fieldSeparators, recordSeparators);
            this.calculateNextSeparators();
        }

        public boolean matchStart(char c) {
            for (int i = 0; i < this.separators.length; ++i) {
                if (!this.separators[i].startsWith(c)) continue;
                this.current = i;
                return true;
            }
            this.current = -1;
            return false;
        }

        public boolean nextCurrent(int offset) {
            this.current = this.nextSeparators[this.current][offset];
            return this.current != -1;
        }

        public Separator getCurrent() {
            return this.current == -1 ? null : this.separators[this.current];
        }

        private void evaluateSeparators(String splitString, String fieldSeparators, String recordSeparator) {
            String[] fs = fieldSeparators.split(splitString);
            String[] rs = recordSeparator.split(splitString);
            this.separators = new Separator[fs.length + rs.length];
            int i = 0;
            for (String f : fs) {
                this.separators[i++] = new FieldSeparator(f);
            }
            for (String r : rs) {
                this.separators[i++] = new RecordSeparator(r);
            }
        }

        private void calculateNextSeparators() {
            this.nextSeparators = new int[this.separators.length][];
            for (int ia = 0; ia < this.separators.length; ++ia) {
                int i;
                Separator a = this.separators[ia];
                int la = a.getLength();
                int[] nexts = new int[la];
                for (i = 0; i < nexts.length; ++i) {
                    nexts[i] = -1;
                }
                block2: for (int ib = 0; ib < this.separators.length; ++ib) {
                    Separator b = this.separators[ib];
                    int lb = b.getLength();
                    for (int i2 = Math.min(la, lb) - 1; i2 >= 0; --i2) {
                        if (nexts[i2] != -1 || !this.separators[ia].matchesAt(b, i2)) continue;
                        nexts[i2] = ib;
                        continue block2;
                    }
                }
                for (i = 0; i < nexts.length; ++i) {
                    if (nexts[i] == -1) continue;
                    for (int j = i; j >= 0; --j) {
                        nexts[j] = nexts[i];
                    }
                    break;
                }
                this.nextSeparators[ia] = nexts;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        VALUE,
        STORE,
        SEPERATOR;

    }

    public static interface Property
    extends GenericCsvReaderFactory.Property {
        public static final String BufferSize = "BufferSize";
    }
}

