/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.springannotation.utils;

import java.lang.reflect.Field;
import net.java.dev.springannotation.annotation.Bean;
import net.java.dev.springannotation.annotation.Property;
import net.java.dev.springannotation.annotation.Scope;
import net.java.dev.springannotation.utils.Scanner;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationBeanDefinitionReader {
    public static RootBeanDefinition readBean(Class<?> c, Bean b, ListableBeanFactory beanFactory) {
        RootBeanDefinition rbd = new RootBeanDefinition();
        rbd.setAbstract(false);
        rbd.setBeanClass(c);
        rbd.setSingleton(b.singleton());
        rbd.setLazyInit(b.lazy());
        if (!"".equals(b.initMethod().trim())) {
            rbd.setInitMethodName(b.initMethod());
        }
        if (!"".equals(b.destroyMethod().trim())) {
            rbd.setDestroyMethodName(b.destroyMethod());
        }
        if (!"".equals(b.factoryMethod().trim())) {
            rbd.setFactoryMethodName(b.factoryMethod());
        }
        rbd.setAutowireCandidate(true);
        rbd.setAutowireMode(b.autoWire().value());
        AnnotationBeanDefinitionReader.readProperties(c, b, rbd, beanFactory);
        if (!Scope.DEFAULT.equals((Object)b.scope())) {
            rbd.setScope(b.scope().getScopeName());
        } else if (!"".equals(b.scopeName().trim())) {
            rbd.setScope(b.scopeName());
        }
        return rbd;
    }

    public static void loadBeansWithAnnotation(ListableBeanFactory beanFactory, BeanDefinitionRegistry beanDefRegistry) {
        for (Class<?> c : new Scanner().getClasses()) {
            Bean b = c.getAnnotation(Bean.class);
            if (b == null) continue;
            RootBeanDefinition rbd = AnnotationBeanDefinitionReader.readBean(c, b, beanFactory);
            String name = b.name();
            if (name == null || "".equals(name.trim())) {
                name = c.getName();
            }
            beanDefRegistry.registerBeanDefinition(name, (BeanDefinition)rbd);
        }
    }

    private static void readProperties(Class<?> c, Bean b, RootBeanDefinition rbd, ListableBeanFactory beanFactory) {
        Field[] fields = c.getDeclaredFields();
        MutablePropertyValues mpv = new MutablePropertyValues();
        for (Field f : fields) {
            Property prop = f.getAnnotation(Property.class);
            if (prop == null) continue;
            if (!"".equals(prop.bean())) {
                mpv.addPropertyValue(f.getName(), (Object)new RuntimeBeanReference(prop.bean()));
                continue;
            }
            mpv.addPropertyValue(f.getName(), (Object)prop.value());
        }
        if (!mpv.isEmpty()) {
            rbd.setPropertyValues(mpv);
        }
    }
}

