/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.vcc.api;

import java.io.IOException;
import java.util.Iterator;
import net.java.dev.vcc.api.Datacenter;
import net.java.dev.vcc.spi.DatacenterConnection;
import net.java.dev.vcc.spi.LogFactoryManager;
import net.java.dev.vcc.util.ServiceLoaderCache;
import net.java.dev.vcc.util.ServiceLoaderProxy;

public final class DatacenterManager {
    private static final ServiceLoaderCache<DatacenterConnection> cache = new ServiceLoaderCache<DatacenterConnection>(DatacenterConnection.class);

    private DatacenterManager() {
    }

    public static Datacenter getConnection(String url, String username, char[] password) throws IOException {
        return DatacenterManager.getConnection(ServiceLoaderProxy.getContextClassLoader(), url, username, password);
    }

    public static Datacenter getConnection(ClassLoader classLoader, String url, String username, char[] password) throws IOException {
        Iterator<DatacenterConnection> i = cache.get(classLoader).iterator();
        while (i.hasNext()) {
            DatacenterConnection manager = i.next();
            if (!manager.acceptsUrl(url)) continue;
            return manager.connect(url, username, password, LogFactoryManager.getLogFactory(classLoader));
        }
        throw new RuntimeException("give this a real exception");
    }
}

