/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.vcc.api;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import net.java.dev.vcc.api.ManagedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ManagedObjectId<T extends ManagedObject>
implements Serializable {
    private final Class<T> managedObjectClass;
    private final String datacenterUrl;

    protected ManagedObjectId(Class<T> managedObjectClass, String datacenterUrl) {
        this.managedObjectClass = managedObjectClass;
        this.datacenterUrl = datacenterUrl;
    }

    public Class<T> getManagedObjectClass() {
        return this.managedObjectClass;
    }

    public String getDatacenterUrl() {
        return this.datacenterUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManagedObjectId that = (ManagedObjectId)o;
        if (!this.datacenterUrl.equals(that.datacenterUrl)) {
            return false;
        }
        return this.managedObjectClass.equals(that.managedObjectClass);
    }

    public int hashCode() {
        int result = this.managedObjectClass.hashCode();
        result = 31 * result + this.datacenterUrl.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.datacenterUrl);
        try {
            sb.append(";class=");
            sb.append(URLEncoder.encode(this.managedObjectClass.getSimpleName(), "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return sb.toString();
    }
}

