/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.vcc.spi;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.java.dev.vcc.api.Computer;
import net.java.dev.vcc.api.ComputerTemplate;
import net.java.dev.vcc.api.DatacenterResourceGroup;
import net.java.dev.vcc.api.Host;
import net.java.dev.vcc.api.HostResourceGroup;
import net.java.dev.vcc.api.ManagedObjectId;
import net.java.dev.vcc.spi.AbstractManagedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDatacenterResourceGroup
extends AbstractManagedObject<DatacenterResourceGroup>
implements DatacenterResourceGroup {
    protected AbstractDatacenterResourceGroup(ManagedObjectId<DatacenterResourceGroup> resourceGroupManagedObjectId) {
        super(resourceGroupManagedObjectId);
    }

    @Override
    public Set<ComputerTemplate> getComputerTemplates() {
        return Collections.emptySet();
    }

    @Override
    public Set<Host> getHosts() {
        return Collections.emptySet();
    }

    @Override
    public Set<DatacenterResourceGroup> getDatacenterResourceGroups() {
        return Collections.emptySet();
    }

    @Override
    public Set<Computer> getAllComputers() {
        HashSet<Computer> result = new HashSet<Computer>();
        for (DatacenterResourceGroup group : this.getDatacenterResourceGroups()) {
            result.addAll(group.getAllComputers());
        }
        for (Host host : this.getHosts()) {
            result.addAll(host.getAllComputers());
        }
        return result;
    }

    @Override
    public Set<ComputerTemplate> getAllComputerTemplates() {
        HashSet<ComputerTemplate> result = new HashSet<ComputerTemplate>(this.getComputerTemplates());
        for (DatacenterResourceGroup group : this.getDatacenterResourceGroups()) {
            result.addAll(group.getAllComputerTemplates());
        }
        for (Host host : this.getHosts()) {
            result.addAll(host.getAllComputerTemplates());
        }
        return result;
    }

    @Override
    public Set<Host> getAllHosts() {
        HashSet<Host> result = new HashSet<Host>(this.getHosts());
        for (DatacenterResourceGroup group : this.getDatacenterResourceGroups()) {
            result.addAll(group.getAllHosts());
        }
        return result;
    }

    @Override
    public Set<HostResourceGroup> getAllHostResourceGroups() {
        HashSet<HostResourceGroup> result = new HashSet<HostResourceGroup>();
        for (DatacenterResourceGroup group : this.getDatacenterResourceGroups()) {
            result.addAll(group.getAllHostResourceGroups());
        }
        for (Host host : this.getHosts()) {
            result.addAll(host.getAllHostResourceGroups());
        }
        return result;
    }

    @Override
    public Set<DatacenterResourceGroup> getAllDatacenterResourceGroups() {
        HashSet<DatacenterResourceGroup> result = new HashSet<DatacenterResourceGroup>(this.getDatacenterResourceGroups());
        for (DatacenterResourceGroup group : this.getDatacenterResourceGroups()) {
            result.addAll(group.getAllDatacenterResourceGroups());
        }
        return result;
    }
}

