/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.vcc.spi;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.java.dev.vcc.api.Log;
import net.java.dev.vcc.spi.AbstractLog;
import net.java.dev.vcc.spi.AbstractLogFactory;

class DefaultLogFactory
extends AbstractLogFactory {
    DefaultLogFactory() {
    }

    protected Log newLog(String name, String bundleName) {
        return new JULLog(name, bundleName);
    }

    private static final class JULLog
    extends AbstractLog {
        private final Logger delegate;

        public JULLog(String name, String bundleName) {
            this.delegate = Logger.getLogger(name, bundleName);
        }

        public boolean isDebugEnabled() {
            return this.delegate.isLoggable(Level.FINE);
        }

        public boolean isInfoEnabled() {
            return this.delegate.isLoggable(Level.INFO);
        }

        public boolean isWarnEnabled() {
            return this.delegate.isLoggable(Level.WARNING);
        }

        public boolean isErrorEnabled() {
            return this.delegate.isLoggable(Level.SEVERE);
        }

        public boolean isFatalEnabled() {
            return this.delegate.isLoggable(Level.SEVERE);
        }

        protected void debug(String fqcn, Throwable throwable, String messageKey, Object[] args) {
            LogRecord rec = new LogRecord(Level.FINE, messageKey);
            rec.setParameters(args);
            rec.setThrown(throwable);
            this.inferCaller(fqcn, rec);
            this.delegate.log(rec);
        }

        protected void info(String fqcn, Throwable throwable, String messageKey, Object[] args) {
            LogRecord rec = new LogRecord(Level.INFO, messageKey);
            rec.setParameters(args);
            rec.setThrown(throwable);
            this.inferCaller(fqcn, rec);
            this.delegate.log(rec);
        }

        protected void warn(String fqcn, Throwable throwable, String messageKey, Object[] args) {
            LogRecord rec = new LogRecord(Level.WARNING, messageKey);
            rec.setParameters(args);
            rec.setThrown(throwable);
            this.inferCaller(fqcn, rec);
            this.delegate.log(rec);
        }

        protected void error(String fqcn, Throwable throwable, String messageKey, Object[] args) {
            LogRecord rec = new LogRecord(Level.SEVERE, messageKey);
            rec.setParameters(args);
            rec.setThrown(throwable);
            this.inferCaller(fqcn, rec);
            this.delegate.log(rec);
        }

        protected void fatal(String fqcn, Throwable throwable, String messageKey, Object[] args) {
            LogRecord rec = new LogRecord(Level.SEVERE, messageKey);
            rec.setParameters(args);
            rec.setThrown(throwable);
            this.inferCaller(fqcn, rec);
            this.delegate.log(rec);
        }

        private void inferCaller(String fqcn, LogRecord rec) {
            StackTraceElement frame;
            String cname;
            int ix;
            StackTraceElement[] stack = new Throwable().getStackTrace();
            for (ix = 0; ix < stack.length && !(cname = (frame = stack[ix]).getClassName()).equals(fqcn); ++ix) {
            }
            while (ix < stack.length) {
                frame = stack[ix];
                cname = frame.getClassName();
                if (!cname.equals(fqcn)) {
                    rec.setSourceClassName(cname);
                    rec.setSourceMethodName(frame.getMethodName());
                    return;
                }
                ++ix;
            }
        }
    }
}

