/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.vcc.util;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FutureReference<T>
implements Future<T> {
    private boolean done = false;
    private T value;
    private String message;
    private Throwable cause;
    private final Lock referenceLock = new ReentrantLock();
    private final Condition completed = this.referenceLock.newCondition();

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        this.referenceLock.lock();
        try {
            boolean bl = this.done;
            return bl;
        }
        finally {
            this.referenceLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.referenceLock.lock();
        try {
            while (!this.done) {
                this.completed.await();
            }
            if (this.cause != null) {
                throw new ExecutionException(this.message, this.cause);
            }
            T t = this.value;
            return t;
        }
        finally {
            this.referenceLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.referenceLock.lock();
        try {
            long nanosTimeout = unit.toNanos(timeout);
            while (!this.done) {
                if (nanosTimeout > 0L) {
                    nanosTimeout = this.completed.awaitNanos(nanosTimeout);
                    continue;
                }
                throw new TimeoutException();
            }
            if (this.cause != null) {
                throw new ExecutionException(this.message, this.cause);
            }
            T t = this.value;
            return t;
        }
        finally {
            this.referenceLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(T value) {
        this.referenceLock.lock();
        try {
            if (this.done) {
                throw new IllegalStateException("Already completed");
            }
            this.done = true;
            this.value = value;
            this.completed.signalAll();
        }
        finally {
            this.referenceLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String message, Throwable cause) {
        this.referenceLock.lock();
        try {
            if (this.done) {
                throw new IllegalStateException("Already completed");
            }
            this.done = true;
            this.message = message;
            this.cause = cause;
            this.completed.signalAll();
        }
        finally {
            this.referenceLock.unlock();
        }
    }
}

