/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.vcc.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.java.dev.vcc.util.ServiceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JDK5ServiceLoaderImpl<S>
implements ServiceLoader<S> {
    private final Class<S> service;
    private final ClassLoader loader;
    private List<String> serviceImplNames = null;

    public JDK5ServiceLoaderImpl(Class<S> service, ClassLoader loader) {
        service.getClass();
        loader.getClass();
        this.service = service;
        this.loader = loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> loadServiceNames(Class<?> clazz, ClassLoader classLoader) {
        Logger logger = Logger.getLogger(JDK5ServiceLoaderImpl.class.getName());
        logger.log(Level.FINEST, "loadServiceNames({0},{1})", new Object[]{clazz, classLoader});
        String resourceName = "META-INF/services/" + clazz.getName();
        ArrayList<String> names = new ArrayList<String>();
        try {
            Enumeration<URL> urlEnumeration = classLoader.getResources(resourceName);
            if (urlEnumeration == null) {
                return Collections.emptyList();
            }
            if (!urlEnumeration.hasMoreElements()) {
                return Collections.emptyList();
            }
            block22: while (urlEnumeration.hasMoreElements()) {
                URL url = urlEnumeration.nextElement();
                try {
                    InputStream inputStream = url.openStream();
                    try {
                        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                        try {
                            BufferedReader reader = new BufferedReader(inputStreamReader);
                            try {
                                String line;
                                while ((line = reader.readLine()) != null) {
                                    int n;
                                    int ci = line.indexOf(35);
                                    if (ci >= 0) {
                                        line = line.substring(0, ci);
                                    }
                                    if ((n = (line = line.trim()).length()) == 0) continue;
                                    if (line.indexOf(32) >= 0 || line.indexOf(9) >= 0) {
                                        logger.log(Level.WARNING, "Illegal configuration-file syntax");
                                        continue block22;
                                    }
                                    int cp = line.codePointAt(0);
                                    if (!Character.isJavaIdentifierStart(cp)) {
                                        logger.log(Level.SEVERE, "Illegal provider-class name: {0}", line);
                                        continue block22;
                                    }
                                    for (int i = Character.charCount(cp); i < n; i += Character.charCount(cp)) {
                                        cp = line.codePointAt(i);
                                        if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
                                        logger.log(Level.SEVERE, "Illegal provider-class name: {0}", line);
                                        continue block22;
                                    }
                                    if (names.contains(line)) continue;
                                    names.add(line);
                                }
                            }
                            finally {
                                reader.close();
                            }
                        }
                        finally {
                            inputStreamReader.close();
                        }
                    }
                    finally {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    logger.log(Level.FINE, "I/O problem", e);
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not determine services", e);
        }
        return Collections.synchronizedList(names);
    }

    @Override
    public synchronized void reload() {
        this.serviceImplNames = null;
    }

    @Override
    public synchronized Iterator<S> iterator() {
        if (this.serviceImplNames == null) {
            this.serviceImplNames = JDK5ServiceLoaderImpl.loadServiceNames(this.service, this.loader);
        }
        return new IteratorImpl<S>(this.service, this.loader, this.serviceImplNames.iterator());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IteratorImpl<S>
    implements Iterator<S> {
        private final Logger logger = Logger.getLogger(IteratorImpl.class.getName());
        private final Class<S> service;
        private final ClassLoader loader;
        private final Iterator<String> names;
        private final Object lock = new Object();
        private S next = null;

        public IteratorImpl(Class<S> service, ClassLoader loader, Iterator<String> names) {
            this.service = service;
            this.loader = loader;
            this.names = names;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            Object object = this.lock;
            synchronized (object) {
                if (this.next != null) {
                    return true;
                }
                while (this.names.hasNext()) {
                    String name = this.names.next();
                    try {
                        Class<?> implClass = this.loader.loadClass(name);
                        if (!this.service.isAssignableFrom(implClass)) {
                            this.logger.log(Level.SEVERE, "{0} does not implement {1}", new Object[]{implClass, this.service});
                            continue;
                        }
                        this.next = implClass.newInstance();
                        return true;
                    }
                    catch (ClassNotFoundException e) {
                        this.logger.log(Level.SEVERE, "Could not find provider", e);
                    }
                    catch (IllegalAccessException e) {
                        this.logger.log(Level.WARNING, "Could not access provider", e);
                    }
                    catch (InstantiationException e) {
                        this.logger.log(Level.WARNING, "Could not instantiate provider", e);
                    }
                    try {
                        this.names.remove();
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {}
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public S next() {
            Object object = this.lock;
            synchronized (object) {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                S s = this.next;
                return s;
                finally {
                    this.next = null;
                }
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

