/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import net.java.quickcheck.Characteristic;
import net.java.quickcheck.Runner;
import net.java.quickcheck.RunnerDecorator;
import net.java.quickcheck.util.Assert;

abstract class AbstractSerializingRunnerDecorator<T>
extends RunnerDecorator<T> {
    public static final String PATH_PREFIX = String.valueOf(System.getProperty("user.name")) + File.separator + "quickcheck" + File.separator;

    public AbstractSerializingRunnerDecorator(Runner<T> decorated) {
        super(decorated);
    }

    @Override
    public final void forAll() {
        String message = String.format("Started %s with decorated %s.", this.getClass().getCanonicalName(), this.getDecorated());
        this.getWriter().println(message);
        this.onForAll();
    }

    protected abstract void onForAll();

    <D> D discoverFiles(Characteristic<?> characteristic, FileDiscovery<D> discovery) {
        String fileName;
        File file;
        int i = 1;
        do {
            fileName = String.valueOf(i++) + ".ser";
        } while (discovery.goOn(file = new File(this.getDirectoryForCharacteristic(characteristic), fileName)));
        return discovery.getResult();
    }

    String getDirectoryForCharacteristic(Characteristic<?> characteristic) {
        String tempDir = System.getProperty("java.io.tmpdir");
        return new File(tempDir, String.valueOf(PATH_PREFIX) + this.characteristicToPath(characteristic)).getAbsolutePath();
    }

    String characteristicToPath(Characteristic<?> characteristic) {
        Assert.notNull(characteristic.name(), "characteristic.name");
        String name = String.valueOf(characteristic.getClass().getName()) + "." + characteristic.name();
        return name.replace(".", File.separator);
    }

    void closeQuietly(Closeable closable) {
        try {
            if (closable != null) {
                closable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static interface FileDiscovery<D> {
        public boolean goOn(File var1);

        public D getResult();
    }
}

