/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck;

import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import net.java.quickcheck.AbstractSerializingRunnerDecorator;
import net.java.quickcheck.Characteristic;
import net.java.quickcheck.Runner;
import net.java.quickcheck.SerializedInstanceHolder;

class DeserializingRunnerDecorator<T>
extends AbstractSerializingRunnerDecorator<T> {
    public DeserializingRunnerDecorator(Runner<T> wrapped) {
        super(wrapped);
    }

    @Override
    protected void onForAll() {
        Characteristic<T> characteristic = this.getDecorated().getCharacteristic();
        List<File> fileNames = this.getFileNames(characteristic);
        this.print(String.format("run deserialized test data (%s found).", fileNames.size()));
        int currentRuns = 0;
        while (currentRuns < fileNames.size()) {
            T read = this.readSerialized(fileNames.get(currentRuns));
            try {
                this.printCurrentValue(currentRuns + 1, read);
                characteristic.specify(read);
            }
            catch (Throwable e) {
                this.throwFailedException(read, e, characteristic, currentRuns + 1);
            }
            ++currentRuns;
        }
    }

    private T readSerialized(File fileName) {
        T t;
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new FileInputStream(fileName));
            Object readObject = ((SerializedInstanceHolder)objectInputStream.readObject()).getInstance();
            t = this.castToT(readObject);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.closeQuietly(objectInputStream);
                throw throwable;
            }
        }
        this.closeQuietly(objectInputStream);
        return t;
    }

    private T castToT(Object readObject) {
        return (T)readObject;
    }

    public List<File> getFileNames(Characteristic<?> characteristic) {
        return this.discoverFiles(characteristic, new AbstractSerializingRunnerDecorator.FileDiscovery<List<File>>(){
            private List<File> result = new ArrayList<File>();

            @Override
            public List<File> getResult() {
                return this.result;
            }

            @Override
            public boolean goOn(File file) {
                if (file.exists()) {
                    this.result.add(file);
                    return true;
                }
                return false;
            }
        });
    }
}

