/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck;

import java.io.PrintWriter;
import net.java.quickcheck.Characteristic;
import net.java.quickcheck.CharacteristicException;
import net.java.quickcheck.Generator;
import net.java.quickcheck.GeneratorException;
import net.java.quickcheck.GuardException;
import net.java.quickcheck.NullWriter;
import net.java.quickcheck.Runner;
import net.java.quickcheck.RunnerFactory;

public class QuickCheck {
    public static final int MAX_NUMBER_OF_RUNS = 200;
    public static final int MIN_NUMBER_OF_RUNS = 1;
    public static final String SYSTEM_PROPERTY_SERIALIZE = QuickCheck.propertyName("SERIALIZE");
    public static final String SYSTEM_PROPERTY_DESERIALIZE = QuickCheck.propertyName("DESERIALIZE");
    public static final String SYSTEM_PROPERTY_SERIALIZE_DELETE_OLD = QuickCheck.propertyName("SERIALIZE.DELETE.OLD");
    public static final String SYSTEM_PROPERTY_RUNS = QuickCheck.propertyName("RUNS");

    public static <T> void forAll(Generator<T> generator, Characteristic<T> characteristic) throws GeneratorException, CharacteristicException {
        new RunnerFactory().createRunnerInstance(characteristic, 200, generator, new PrintWriter(new NullWriter())).forAll();
    }

    public static int getDefaultNumberOfRuns() {
        Integer runs = Integer.getInteger(SYSTEM_PROPERTY_RUNS, 200);
        return Math.max(1, runs);
    }

    private static String propertyName(String name) {
        return String.valueOf(QuickCheck.class.getSimpleName()) + "." + name;
    }

    public static <T> void forAll(int runs, Generator<T> generator, Characteristic<T> characteristic) throws GeneratorException, CharacteristicException {
        Runner<T> runner = new RunnerFactory().createRunnerInstance(characteristic, runs, generator, new PrintWriter(new NullWriter()));
        runner.forAll();
    }

    public static <T> void forAllVerbose(Generator<T> generator, Characteristic<T> characteristic) throws GeneratorException, CharacteristicException {
        Runner<T> runner = new RunnerFactory().createRunnerInstance(characteristic, 200, generator, new PrintWriter(new PrintWriter(System.out)));
        runner.forAll();
    }

    public static <T> void forAllVerbose(int runs, Generator<T> generator, Characteristic<T> characteristic) throws GeneratorException, CharacteristicException {
        Runner<T> runner = new RunnerFactory().createRunnerInstance(characteristic, runs, generator, new PrintWriter(new PrintWriter(System.out)));
        runner.forAll();
    }

    public static void guard(boolean predicate) {
        if (!predicate) {
            throw new GuardException();
        }
    }
}

