/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck;

import java.io.PrintWriter;
import net.java.quickcheck.Characteristic;
import net.java.quickcheck.DeserializingRunnerDecorator;
import net.java.quickcheck.Generator;
import net.java.quickcheck.NullWriter;
import net.java.quickcheck.QuickCheck;
import net.java.quickcheck.Runner;
import net.java.quickcheck.RunnerImpl;
import net.java.quickcheck.SerializingRunnerDecorator;

public class RunnerFactory {
    public Runner<Object> createRunner(Generator<Object> generator, int runs, Characteristic<Object> characteristic, boolean verbose) {
        PrintWriter writer = verbose ? new PrintWriter(System.out) : new PrintWriter(new NullWriter());
        return this.createRunnerInstance(characteristic, runs, generator, writer);
    }

    public <T> Runner<T> createRunnerInstance(Characteristic<T> characteristic, int runs, Generator<T> generator, PrintWriter writer) {
        Runner<T> runner = this.createSimpleRunner(characteristic, runs, generator, writer);
        if (Boolean.getBoolean(QuickCheck.SYSTEM_PROPERTY_SERIALIZE)) {
            return new SerializingRunnerDecorator<T>(runner, Boolean.getBoolean(QuickCheck.SYSTEM_PROPERTY_SERIALIZE_DELETE_OLD));
        }
        if (Boolean.getBoolean(QuickCheck.SYSTEM_PROPERTY_DESERIALIZE)) {
            return new DeserializingRunnerDecorator<T>(runner);
        }
        return runner;
    }

    <T> Runner<T> createSimpleRunner(Characteristic<T> characteristic, int runs, Generator<T> generator, PrintWriter writer) {
        RunnerImpl<T> runnerImpl = new RunnerImpl<T>();
        runnerImpl.setCharacteristic(characteristic);
        runnerImpl.setRuns(runs);
        runnerImpl.setGenerator(generator);
        runnerImpl.setWriter(writer);
        return runnerImpl;
    }
}

