/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck;

import java.io.PrintWriter;
import net.java.quickcheck.AbstractRunner;
import net.java.quickcheck.Characteristic;
import net.java.quickcheck.CharacteristicException;
import net.java.quickcheck.Generator;
import net.java.quickcheck.GeneratorException;
import net.java.quickcheck.GuardException;
import net.java.quickcheck.QuickCheck;
import net.java.quickcheck.util.Assert;

class RunnerImpl<T>
extends AbstractRunner<T> {
    private int fMaxRuns;
    private int fCurrentRuns;
    private int fRuns;
    private PrintWriter fWriter;
    private Characteristic<T> fCharacteristic;
    private Generator<T> fGenerator;

    public RunnerImpl() {
        this.setRuns(QuickCheck.getDefaultNumberOfRuns());
    }

    @Override
    public void forAll() {
        Assert.notNull(this.fCharacteristic, "characteristic");
        Assert.notNull(this.fGenerator, "generator");
        int count = 0;
        while (count < this.fRuns) {
            try {
                this.doSetup();
                this.check(this.fGenerator);
            }
            finally {
                this.doTearDown();
            }
            ++count;
        }
    }

    private void check(Generator<T> generator) {
        Assert.notNull(generator, "generator");
        while (this.fCurrentRuns < this.fMaxRuns) {
            ++this.fCurrentRuns;
            T value = generator.next();
            this.printCurrentValue(this.fCurrentRuns, value);
            try {
                this.fCharacteristic.specify(value);
                return;
            }
            catch (GuardException e) {
                this.print(String.format("%d: skipped [%s]", this.fCurrentRuns, value));
            }
            catch (Throwable e) {
                this.throwFailedException(value, e, this.fCharacteristic, this.fCurrentRuns);
            }
        }
        throw new GeneratorException(String.format("Generator max tries (%s) reached. Check your guard expressions.", this.fMaxRuns), generator);
    }

    public static int getMaxGeneratorTries(int maxRuns) {
        return maxRuns * 10;
    }

    private void doTearDown() {
        try {
            this.fCharacteristic.tearDown();
        }
        catch (Exception e) {
            throw new CharacteristicException("teardown failed", e, this.fCharacteristic);
        }
    }

    private void doSetup() {
        try {
            this.fCharacteristic.setUp();
        }
        catch (Exception e) {
            throw new CharacteristicException("setup failed", e, this.fCharacteristic);
        }
    }

    @Override
    public PrintWriter getWriter() {
        return this.fWriter;
    }

    public void setWriter(PrintWriter writer) {
        this.fWriter = writer;
    }

    @Override
    public int getRuns() {
        return this.fRuns;
    }

    public void setRuns(int runs) {
        Assert.greaterOrEqual(1.0, runs, "runs");
        this.fMaxRuns = 10 * runs;
        this.fRuns = runs;
    }

    @Override
    public Characteristic<T> getCharacteristic() {
        return this.fCharacteristic;
    }

    public void setCharacteristic(Characteristic<T> characteristic) {
        this.fCharacteristic = characteristic;
    }

    @Override
    public Generator<T> getGenerator() {
        return this.fGenerator;
    }

    public void setGenerator(Generator<T> generator) {
        this.fGenerator = generator;
    }
}

