/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import net.java.quickcheck.AbstractSerializingRunnerDecorator;
import net.java.quickcheck.Characteristic;
import net.java.quickcheck.CharacteristicException;
import net.java.quickcheck.Runner;
import net.java.quickcheck.SerializableInstanceHolder;
import net.java.quickcheck.SerializedInstanceHolder;
import net.java.quickcheck.UnserializableInstanceHolder;

class SerializingRunnerDecorator<T>
extends AbstractSerializingRunnerDecorator<T> {
    private boolean deleteOldFiles;

    public SerializingRunnerDecorator(Runner<T> decorated, boolean deleteOld) {
        super(decorated);
        this.deleteOldFiles = deleteOld;
    }

    @Override
    protected void onForAll() {
        this.getWriter().println(String.format("Delete old files %s", this.deleteOldFiles));
        try {
            if (this.deleteOldFiles) {
                this.deleteOldFilesInDir();
            }
            this.getDecorated().forAll();
        }
        catch (CharacteristicException e) {
            this.serialize(e);
            throw e;
        }
    }

    private void deleteOldFilesInDir() {
        File dirForCharacteristic = new File(this.getDirectoryForCharacteristic(this.getDecorated().getCharacteristic()));
        if (dirForCharacteristic.isDirectory()) {
            String[] stringArray = dirForCharacteristic.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                new File(dirForCharacteristic, file).delete();
                ++n2;
            }
        }
    }

    boolean deleteOldFiles() {
        return this.deleteOldFiles;
    }

    void serialize(CharacteristicException e) {
        File file = this.getFileName(e.getCharateristic());
        try {
            this.writeHolder(file, new SerializableInstanceHolder(e.getInstance()));
        }
        catch (IOException firstTry) {
            try {
                this.writeHolder(file, new UnserializableInstanceHolder(e.getInstance().toString(), e));
            }
            catch (IOException holderTry) {
                throw new RuntimeException(holderTry);
            }
        }
    }

    private void writeHolder(File file, SerializedInstanceHolder serializedInstanceHolderImpl) throws IOException {
        ObjectOutputStream objectOutputStream = null;
        try {
            file.getParentFile().mkdirs();
            objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            objectOutputStream.writeObject(serializedInstanceHolderImpl);
        }
        catch (Throwable throwable) {
            this.closeQuietly(objectOutputStream);
            throw throwable;
        }
        this.closeQuietly(objectOutputStream);
    }

    File getFileName(Characteristic<?> c) {
        return this.discoverFiles(c, new AbstractSerializingRunnerDecorator.FileDiscovery<File>(){
            private File result;

            @Override
            public boolean goOn(File file) {
                this.result = file;
                return file.exists();
            }

            @Override
            public File getResult() {
                return this.result;
            }
        });
    }
}

