/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.characteristic;

import net.java.quickcheck.Characteristic;
import net.java.quickcheck.characteristic.Classification;

public abstract class AbstractCharacteristic<T>
implements Characteristic<T> {
    private final Classification classification = new Classification();
    private final String name;

    public AbstractCharacteristic() {
        this(null);
    }

    public AbstractCharacteristic(String name) {
        this.name = name;
    }

    @Override
    public void specify(T any) throws Throwable {
        this.doSpecify(any);
        this.classification.call();
    }

    protected void classify(boolean predicate, Object classification) {
        this.classification.doClassify(predicate, classification);
    }

    protected void classify(Object classification) {
        this.classify(true, classification);
    }

    protected abstract void doSpecify(T var1) throws Throwable;

    public Classification getClassification() {
        return this.classification;
    }

    @Override
    public void setUp() throws Exception {
    }

    @Override
    public void tearDown() throws Exception {
    }

    @Override
    public String name() {
        return this.name;
    }
}

