/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.characteristic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.java.quickcheck.collection.Pair;

public class Classification {
    private final HashMap<Object, Integer> classifications = new HashMap();
    private int total;
    private boolean reportState;
    private HashMap<Object, Double> classifiedWithPercents;
    private ArrayList<Object> sortedCategories;
    private static ThreadLocal<Classification> gathered = new ThreadLocal<Classification>(){

        @Override
        protected Classification initialValue() {
            return new Classification();
        }
    };

    public double getFrequency(Object classification) {
        this.reportState();
        Double frequency = this.getClassified().get(classification);
        return frequency == null ? 0.0 : frequency;
    }

    public List<Object> getCategories() {
        this.reportState();
        if (this.sortedCategories == null) {
            ArrayList<Pair<Object, Double>> toSort = this.buildCategoryFrequencyList();
            this.sortByFrequency(toSort);
            this.sortedCategories = this.transFormPairListToCategoryList(toSort);
        }
        return this.sortedCategories;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Map<Object, Double> classified = this.getClassified();
        builder.append("Classifications :");
        List<Object> categories = this.getCategories();
        for (Object key : categories) {
            builder.append(String.format("\n%s = %1.2f%%", key, classified.get(key)));
        }
        if (classified.isEmpty()) {
            builder.append("none");
        }
        return builder.toString();
    }

    public void doClassify(boolean predicate, Object classification) {
        this.checkReportState();
        if (!predicate) {
            return;
        }
        boolean categoryFound = this.classifications.containsKey(classification);
        int current = categoryFound ? this.classifications.get(classification) : 0;
        this.classifications.put(classification, ++current);
    }

    public void call() {
        this.checkReportState();
        ++this.total;
    }

    private Map<Object, Double> getClassified() {
        if (this.classifiedWithPercents == null) {
            this.classifiedWithPercents = new HashMap();
            for (Object key : this.classifications.keySet()) {
                double count = this.classifications.get(key).intValue();
                double percent = count * 100.0 / (double)this.total;
                this.classifiedWithPercents.put(key, percent);
            }
        }
        return this.classifiedWithPercents;
    }

    private void reportState() {
        this.reportState = true;
    }

    private ArrayList<Pair<Object, Double>> buildCategoryFrequencyList() {
        Map<Object, Double> classified = this.getClassified();
        ArrayList<Pair<Object, Double>> toSort = new ArrayList<Pair<Object, Double>>();
        for (Map.Entry<Object, Double> e : classified.entrySet()) {
            toSort.add(new Pair<Object, Double>(e.getKey(), e.getValue()));
        }
        return toSort;
    }

    private ArrayList<Object> transFormPairListToCategoryList(ArrayList<Pair<Object, Double>> toSort) {
        ArrayList<Object> sortedCategoryList = new ArrayList<Object>();
        for (Pair<Object, Double> pair : toSort) {
            sortedCategoryList.add(pair.getFirst());
        }
        return sortedCategoryList;
    }

    private void sortByFrequency(ArrayList<Pair<Object, Double>> toSort) {
        Collections.sort(toSort, new Comparator<Pair<Object, Double>>(){

            @Override
            public int compare(Pair<Object, Double> o1, Pair<Object, Double> o2) {
                return o2.getSecond().compareTo(o1.getSecond());
            }
        });
    }

    private void checkReportState() {
        if (this.reportState) {
            throw new IllegalStateException("do not call after report was started.");
        }
    }

    public static Classification gathered() {
        return gathered.get();
    }

    public static void classify(Object classification) {
        Classification.classify(true, classification);
    }

    public static void classify(boolean condition, Object classification) {
        Classification.gathered().doClassify(condition, classification);
    }

    public static void clear() {
        gathered.remove();
    }

    public static void callDone() {
        Classification.gathered().call();
    }

    public void classifyCall(boolean predicate, Object classification) {
        this.doClassify(predicate, classification);
        this.call();
    }

    public void classifyCall(Object classification) {
        this.classifyCall(true, classification);
    }
}

