/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.characteristic;

import java.util.ArrayList;
import java.util.List;
import net.java.quickcheck.characteristic.Classification;
import net.java.quickcheck.characteristic.Operator;

public class ClassificationExpectation {
    private final List<Expectation> expectations = new ArrayList<Expectation>();
    private static ThreadLocal<Holder> gathered = new ThreadLocal<Holder>(){

        @Override
        protected Holder initialValue() {
            return new Holder();
        }
    };

    public ClassificationExpectation expect(Object classification, Operator operator, double expected) {
        this.expectations.add(new Expectation(classification, operator, expected));
        return this;
    }

    public boolean validate(Classification classification) {
        for (Expectation expectation : this.expectations) {
            double frequency;
            if (expectation.check(frequency = classification.getFrequency(expectation.classification))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return String.format("ClassificationExpectation%s", this.expectations);
    }

    public static void expect(ClassificationExpectation classificationExpectation) {
        ClassificationExpectation.getHolder().value = classificationExpectation;
    }

    private static Holder getHolder() {
        return gathered.get();
    }

    public static ClassificationExpectation gathered() {
        return ClassificationExpectation.getHolder().value;
    }

    public static void clear() {
        ClassificationExpectation.getHolder().value = null;
    }

    static boolean gather() {
        return ClassificationExpectation.gathered() != null;
    }

    private static class Expectation {
        private final Object classification;
        private final Operator operator;
        private final double expected;

        public Expectation(Object classification, Operator operator, double expected) {
            this.classification = classification;
            this.operator = operator;
            this.expected = expected;
        }

        public boolean check(double actual) {
            return this.operator.check(actual, this.expected);
        }

        public String toString() {
            return String.format("Expectation[classification=%s, operator=%s, expected=%s]", new Object[]{this.classification, this.operator, this.expected});
        }
    }

    private static class Holder {
        public ClassificationExpectation value;

        private Holder() {
        }
    }
}

