/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.generator;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.java.quickcheck.ExtendibleGenerator;
import net.java.quickcheck.FrequencyGenerator;
import net.java.quickcheck.Generator;
import net.java.quickcheck.StatefulGenerator;
import net.java.quickcheck.collection.Pair;
import net.java.quickcheck.collection.Triple;
import net.java.quickcheck.generator.PrimitiveGenerators;
import net.java.quickcheck.generator.support.ArrayGenerator;
import net.java.quickcheck.generator.support.ByteArrayGenerator;
import net.java.quickcheck.generator.support.DefaultFrequencyGenerator;
import net.java.quickcheck.generator.support.EnsuredValuesGenerator;
import net.java.quickcheck.generator.support.ExcludingGenerator;
import net.java.quickcheck.generator.support.FixedValuesGenerator;
import net.java.quickcheck.generator.support.IntegerArrayGenerator;
import net.java.quickcheck.generator.support.IntegerGenerator;
import net.java.quickcheck.generator.support.IteratorGenerator;
import net.java.quickcheck.generator.support.ListGenerator;
import net.java.quickcheck.generator.support.SetGenerator;
import net.java.quickcheck.generator.support.SortedListGenerator;
import net.java.quickcheck.generator.support.TupleGenerator;
import net.java.quickcheck.generator.support.UniqueValuesGenerator;

public class CombinedGenerators {
    public static <T> FrequencyGenerator<T> frequency(Generator<T> generator, int weight) {
        return new DefaultFrequencyGenerator<T>(generator, weight);
    }

    public static <T> ExtendibleGenerator<T, T> oneOf(Generator<T> generator) {
        return CombinedGenerators.frequency(generator, 1);
    }

    public static <T> Generator<List<T>> vectors(Generator<T> content, int size) {
        return new ListGenerator<T>(content, new FixedValuesGenerator<Integer>(size));
    }

    public static <A, B> Generator<Pair<A, B>> pairs(Generator<A> first, Generator<B> second) {
        final TupleGenerator generator = new TupleGenerator(first, second);
        return new Generator<Pair<A, B>>(){

            @Override
            public Pair<A, B> next() {
                Object[] next = generator.next();
                return new Pair<Object, Object>(next[0], next[1]);
            }
        };
    }

    public static <A, B, C> Generator<Triple<A, B, C>> triples(Generator<A> first, Generator<B> second, Generator<C> third) {
        final TupleGenerator generator = new TupleGenerator(first, second, third);
        return new Generator<Triple<A, B, C>>(){

            @Override
            public Triple<A, B, C> next() {
                Object[] next = generator.next();
                return new Triple<Object, Object, Object>(next[0], next[1], next[2]);
            }
        };
    }

    public static <T> Generator<T> nullsAnd(Generator<T> generator) {
        return CombinedGenerators.nullsAnd(generator, 5);
    }

    public static <T> Generator<T> nullsAnd(Generator<T> generator, int weight) {
        return new DefaultFrequencyGenerator<T>(PrimitiveGenerators.nulls(), 1).add(generator, weight);
    }

    public static <T> Generator<Set<T>> sets(Generator<T> content) {
        return new SetGenerator<T>(content);
    }

    public static <T> Generator<Set<T>> sets(Generator<T> content, Generator<Integer> size) {
        return new SetGenerator<T>(content, size);
    }

    public static <T> Generator<Set<T>> sets(Generator<T> content, int low, int high) {
        return new SetGenerator<T>(content, PrimitiveGenerators.integers(low, high));
    }

    public static <T> Generator<Set<T>> nonEmptySets(Generator<T> content) {
        return CombinedGenerators.sets(content, 1, 10);
    }

    public static <T> Generator<Iterator<T>> iterators(Generator<T> content) {
        return new IteratorGenerator<T>(content);
    }

    public static <T> Generator<Iterator<T>> nonEmptyIterators(Generator<T> content) {
        return new IteratorGenerator<T>(content, 1, 10);
    }

    public static <T> Generator<Iterator<T>> iterators(Generator<T> content, Generator<Integer> size) {
        return new IteratorGenerator<T>(content, size);
    }

    public static <T> Generator<List<T>> lists(Generator<T> content) {
        return new ListGenerator<T>(content);
    }

    public static <T> Generator<List<T>> nonEmptyLists(Generator<T> content) {
        return CombinedGenerators.lists(content, PrimitiveGenerators.positiveIntegers(10));
    }

    public static <T> Generator<List<T>> lists(Generator<T> content, Generator<Integer> size) {
        return new ListGenerator<T>(content, size);
    }

    public static <T> Generator<List<T>> lists(Generator<T> content, int low, int high) {
        return CombinedGenerators.lists(content, new IntegerGenerator(low, high));
    }

    public static <T> Generator<List<T>> lists(Generator<T> content, int low) {
        return CombinedGenerators.lists(content, low, 10);
    }

    public static <T extends Comparable<T>> Generator<List<T>> sortedLists(Generator<T> content) {
        return new SortedListGenerator<T>(content);
    }

    public static <T extends Comparable<T>> Generator<List<T>> sortedLists(Generator<T> content, int low, int high) {
        return CombinedGenerators.sortedLists(content, PrimitiveGenerators.integers(low, high));
    }

    public static <T extends Comparable<T>> Generator<List<T>> sortedLists(Generator<T> content, Generator<Integer> size) {
        return new SortedListGenerator<T>(content, size);
    }

    public static <T> Generator<T[]> arrays(Generator<T> content, Class<T> type) {
        return new ArrayGenerator<T>(content, type);
    }

    public static <T> Generator<T[]> nonEmptyArrays(Generator<T> content, Class<T> type) {
        return CombinedGenerators.arrays(content, PrimitiveGenerators.positiveIntegers(10), type);
    }

    public static <T> Generator<T[]> arrays(Generator<T> content, Generator<Integer> size, Class<T> type) {
        return new ArrayGenerator<T>(content, size, type);
    }

    public static Generator<byte[]> byteArrays() {
        return new ByteArrayGenerator();
    }

    public static Generator<byte[]> byteArrays(Generator<Integer> size) {
        return new ByteArrayGenerator(size);
    }

    public static Generator<byte[]> byteArrays(Generator<Byte> content, Generator<Integer> size) {
        return new ByteArrayGenerator(content, size);
    }

    public static Generator<int[]> intArrays() {
        return new IntegerArrayGenerator();
    }

    public static Generator<int[]> intArrays(Generator<Integer> size) {
        return new IntegerArrayGenerator(size);
    }

    public static Generator<int[]> intArrays(Generator<Integer> content, Generator<Integer> size) {
        return new IntegerArrayGenerator(content, size);
    }

    public static <T> StatefulGenerator<T> ensureValues(Collection<T> ensuredValues) {
        return new EnsuredValuesGenerator<T>(ensuredValues);
    }

    public static <T> StatefulGenerator<T> ensureValues(T ... content) {
        return CombinedGenerators.ensureValues((Collection)Arrays.asList(content));
    }

    public static <T> StatefulGenerator<T> ensureValues(Collection<T> ensuredValues, Generator<T> otherValues) {
        return new EnsuredValuesGenerator<T>(ensuredValues, otherValues);
    }

    public static <T> StatefulGenerator<T> uniqueValues(Generator<T> generator, int tries) {
        return new UniqueValuesGenerator<T>(generator, tries);
    }

    public static <T> StatefulGenerator<T> uniqueValues(Generator<T> generator) {
        return new UniqueValuesGenerator<T>(generator);
    }

    public static <T> Generator<T> exclude(Generator<T> generator, T ... excluded) {
        return CombinedGenerators.exclude(generator, (Collection)Arrays.asList(excluded));
    }

    public static <T> Generator<T> exclude(Generator<T> generator, Collection<T> excluded) {
        return new ExcludingGenerator<T>(generator, excluded);
    }
}

