/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.generator;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.java.quickcheck.Generator;
import net.java.quickcheck.collection.Pair;
import net.java.quickcheck.collection.Triple;
import net.java.quickcheck.generator.CombinedGenerators;
import net.java.quickcheck.generator.iterable.Iterables;

public class CombinedGeneratorsIterables {
    public static <T> Iterable<T> someOneOf(Generator<T> generator) {
        return Iterables.toIterable(CombinedGenerators.oneOf(generator));
    }

    public static <T> Iterable<Iterator<T>> someNonEmptyIterators(Generator<T> content) {
        return Iterables.toIterable(CombinedGenerators.nonEmptyIterators(content));
    }

    public static <T> Iterable<T> someUniqueValues(Generator<T> generator) {
        return Iterables.toIterable(CombinedGenerators.uniqueValues(generator));
    }

    public static <T> Iterable<T> someUniqueValues(Generator<T> generator, int tries) {
        return Iterables.toIterable(CombinedGenerators.uniqueValues(generator, tries));
    }

    public static <T> Iterable<T> someFrequency(Generator<T> generator, int weight) {
        return Iterables.toIterable(CombinedGenerators.frequency(generator, weight));
    }

    public static <T> Iterable<List<T>> someNonEmptyLists(Generator<T> content) {
        return Iterables.toIterable(CombinedGenerators.nonEmptyLists(content));
    }

    public static <T> Iterable<T> someEnsureValues(Collection<T> ensuredValues, Generator<T> otherValues) {
        return Iterables.toIterable(CombinedGenerators.ensureValues(ensuredValues, otherValues));
    }

    public static <T> Iterable<T> someEnsureValues(T[] content) {
        return Iterables.toIterable(CombinedGenerators.ensureValues(content));
    }

    public static <T> Iterable<T> someEnsureValues(Collection<T> ensuredValues) {
        return Iterables.toIterable(CombinedGenerators.ensureValues(ensuredValues));
    }

    public static <T> Iterable<Set<T>> someSets(Generator<T> content, int low, int high) {
        return Iterables.toIterable(CombinedGenerators.sets(content, low, high));
    }

    public static <T> Iterable<Set<T>> someSets(Generator<T> content, Generator<Integer> size) {
        return Iterables.toIterable(CombinedGenerators.sets(content, size));
    }

    public static <T> Iterable<Set<T>> someSets(Generator<T> content) {
        return Iterables.toIterable(CombinedGenerators.sets(content));
    }

    public static Iterable<int[]> someIntArrays(Generator<Integer> size) {
        return Iterables.toIterable(CombinedGenerators.intArrays(size));
    }

    public static Iterable<int[]> someIntArrays() {
        return Iterables.toIterable(CombinedGenerators.intArrays());
    }

    public static Iterable<int[]> someIntArrays(Generator<Integer> content, Generator<Integer> size) {
        return Iterables.toIterable(CombinedGenerators.intArrays(content, size));
    }

    public static <T> Iterable<Set<T>> someNonEmptySets(Generator<T> content) {
        return Iterables.toIterable(CombinedGenerators.nonEmptySets(content));
    }

    public static <T> Iterable<List<T>> someLists(Generator<T> content) {
        return Iterables.toIterable(CombinedGenerators.lists(content));
    }

    public static <T> Iterable<List<T>> someLists(Generator<T> content, Generator<Integer> size) {
        return Iterables.toIterable(CombinedGenerators.lists(content, size));
    }

    public static <T> Iterable<List<T>> someLists(Generator<T> content, int low, int high) {
        return Iterables.toIterable(CombinedGenerators.lists(content, low, high));
    }

    public static <T> Iterable<List<T>> someLists(Generator<T> content, int low) {
        return Iterables.toIterable(CombinedGenerators.lists(content, low));
    }

    public static <T> Iterable<T[]> someNonEmptyArrays(Generator<T> content, Class<T> type) {
        return Iterables.toIterable(CombinedGenerators.nonEmptyArrays(content, type));
    }

    public static <A, B> Iterable<Pair<A, B>> somePairs(Generator<A> first, Generator<B> second) {
        return Iterables.toIterable(CombinedGenerators.pairs(first, second));
    }

    public static Iterable<byte[]> someByteArrays(Generator<Byte> content, Generator<Integer> size) {
        return Iterables.toIterable(CombinedGenerators.byteArrays(content, size));
    }

    public static Iterable<byte[]> someByteArrays(Generator<Integer> size) {
        return Iterables.toIterable(CombinedGenerators.byteArrays(size));
    }

    public static Iterable<byte[]> someByteArrays() {
        return Iterables.toIterable(CombinedGenerators.byteArrays());
    }

    public static <T> Iterable<T> someExclude(Generator<T> generator, Collection<T> excluded) {
        return Iterables.toIterable(CombinedGenerators.exclude(generator, excluded));
    }

    public static <T> Iterable<T> someExclude(Generator<T> generator, T[] excluded) {
        return Iterables.toIterable(CombinedGenerators.exclude(generator, excluded));
    }

    public static <T> Iterable<Iterator<T>> someIterators(Generator<T> content) {
        return Iterables.toIterable(CombinedGenerators.iterators(content));
    }

    public static <T> Iterable<Iterator<T>> someIterators(Generator<T> content, Generator<Integer> size) {
        return Iterables.toIterable(CombinedGenerators.iterators(content, size));
    }

    public static <T> Iterable<List<T>> someVectors(Generator<T> content, int size) {
        return Iterables.toIterable(CombinedGenerators.vectors(content, size));
    }

    public static <A, B, C> Iterable<Triple<A, B, C>> someTriples(Generator<A> first, Generator<B> second, Generator<C> third) {
        return Iterables.toIterable(CombinedGenerators.triples(first, second, third));
    }

    public static <T extends Comparable<T>> Iterable<List<T>> someSortedLists(Generator<T> content, Generator<Integer> size) {
        return Iterables.toIterable(CombinedGenerators.sortedLists(content, size));
    }

    public static <T extends Comparable<T>> Iterable<List<T>> someSortedLists(Generator<T> content, int low, int high) {
        return Iterables.toIterable(CombinedGenerators.sortedLists(content, low, high));
    }

    public static <T extends Comparable<T>> Iterable<List<T>> someSortedLists(Generator<T> content) {
        return Iterables.toIterable(CombinedGenerators.sortedLists(content));
    }

    public static <T> Iterable<T> someNullsAnd(Generator<T> generator, int weight) {
        return Iterables.toIterable(CombinedGenerators.nullsAnd(generator, weight));
    }

    public static <T> Iterable<T[]> someArrays(Generator<T> content, Generator<Integer> size, Class<T> type) {
        return Iterables.toIterable(CombinedGenerators.arrays(content, size, type));
    }

    public static <T> Iterable<T[]> someArrays(Generator<T> content, Class<T> type) {
        return Iterables.toIterable(CombinedGenerators.arrays(content, type));
    }

    public static <T> Iterable<T> someNullsAnd(Generator<T> generator) {
        return Iterables.toIterable(CombinedGenerators.nullsAnd(generator));
    }
}

