/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.generator;

import java.util.Collection;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import net.java.quickcheck.Generator;
import net.java.quickcheck.generator.PrimitiveGenerators;
import net.java.quickcheck.generator.distribution.Distribution;

public class PrimitiveGeneratorSamples {
    public static Integer anyInteger() {
        return PrimitiveGenerators.integers().next();
    }

    public static Integer anyInteger(int low) {
        return PrimitiveGenerators.integers(low).next();
    }

    public static Integer anyInteger(int lo, int hi) {
        return PrimitiveGenerators.integers(lo, hi).next();
    }

    public static Integer anyInteger(int lo, int hi, Distribution distribution) {
        return PrimitiveGenerators.integers(lo, hi, distribution).next();
    }

    public static Integer anyPositiveInteger() {
        return PrimitiveGenerators.positiveIntegers().next();
    }

    public static Integer anyPositiveInteger(int high) {
        return PrimitiveGenerators.positiveIntegers(high).next();
    }

    public static <T> T anyNull() {
        return PrimitiveGenerators.nulls().next();
    }

    public static Long anyLong() {
        return PrimitiveGenerators.longs().next();
    }

    public static Long anyLong(long lo, long hi) {
        return PrimitiveGenerators.longs(lo, hi).next();
    }

    public static Long anyLong(long lo, long hi, Distribution distribution) {
        return PrimitiveGenerators.longs(lo, hi, distribution).next();
    }

    public static <T> T anyObject(Class<T> objectType) {
        return PrimitiveGenerators.objects(objectType).next();
    }

    public static <T> T anyClonedValue(T prototype) {
        return PrimitiveGenerators.clonedValues(prototype).next();
    }

    public static Boolean anyBoolean() {
        return PrimitiveGenerators.booleans().next();
    }

    public static String anyLetterString() {
        return (String)PrimitiveGenerators.letterStrings().next();
    }

    public static String anyLetterString(int min, int max) {
        return (String)PrimitiveGenerators.letterStrings(min, max).next();
    }

    public static <T> T anyDefaultObject(Class<T> objectType) {
        return PrimitiveGenerators.defaultObjects(objectType).next();
    }

    public static Character anyCharacter(char lo, char hi) {
        return PrimitiveGenerators.characters(lo, hi).next();
    }

    public static Character anyCharacter(Character[] chars) {
        return PrimitiveGenerators.characters(chars).next();
    }

    public static Character anyCharacter(String string) {
        return PrimitiveGenerators.characters(string).next();
    }

    public static Character anyCharacter(Collection<Character> chars) {
        return PrimitiveGenerators.characters(chars).next();
    }

    public static Byte anyByte() {
        return PrimitiveGenerators.bytes().next();
    }

    public static Byte anyByte(byte lo, byte hi) {
        return PrimitiveGenerators.bytes(lo, hi).next();
    }

    public static Byte anyByte(byte lo, byte hi, Distribution distribution) {
        return PrimitiveGenerators.bytes(lo, hi, distribution).next();
    }

    public static String anyString(Generator<Character> characterGenerator) {
        return (String)PrimitiveGenerators.strings(characterGenerator).next();
    }

    public static String anyString(Generator<Integer> length, Generator<Character> characters) {
        return (String)PrimitiveGenerators.strings(length, characters).next();
    }

    public static String anyString() {
        return (String)PrimitiveGenerators.strings().next();
    }

    public static String anyString(char lo, char hi) {
        return (String)PrimitiveGenerators.strings(lo, hi).next();
    }

    public static String anyString(String allowedCharacters) {
        return (String)PrimitiveGenerators.strings(allowedCharacters).next();
    }

    public static String anyString(String allowedCharacters, int min, int max) {
        return (String)PrimitiveGenerators.strings(allowedCharacters, min, max).next();
    }

    public static String anyString(int max) {
        return (String)PrimitiveGenerators.strings(max).next();
    }

    public static String anyString(int min, int max) {
        return (String)PrimitiveGenerators.strings(min, max).next();
    }

    public static Character anyBasicLatinCharacter() {
        return PrimitiveGenerators.basicLatinCharacters().next();
    }

    public static String anyPrintableString() {
        return (String)PrimitiveGenerators.printableStrings().next();
    }

    public static Date anyDate(Long low, Long high, TimeUnit precision) {
        return PrimitiveGenerators.dates(low, high, precision).next();
    }

    public static Date anyDate(long low, long high) {
        return PrimitiveGenerators.dates(low, high).next();
    }

    public static Date anyDate() {
        return PrimitiveGenerators.dates().next();
    }

    public static Date anyDate(TimeUnit precision) {
        return PrimitiveGenerators.dates(precision).next();
    }

    public static Date anyDate(Date low, Date high) {
        return PrimitiveGenerators.dates(low, high).next();
    }

    public static Double anyDouble(double lo, double hi, Distribution distribution) {
        return PrimitiveGenerators.doubles(lo, hi, distribution).next();
    }

    public static Double anyDouble(double lo, double hi) {
        return PrimitiveGenerators.doubles(lo, hi).next();
    }

    public static Double anyDouble() {
        return PrimitiveGenerators.doubles().next();
    }

    public static Character anyLatin1SupplementCharacter() {
        return PrimitiveGenerators.latin1SupplementCharacters().next();
    }

    public static String anyNonEmptyString() {
        return (String)PrimitiveGenerators.nonEmptyStrings().next();
    }

    public static Long anyPositiveLong() {
        return PrimitiveGenerators.positiveLongs().next();
    }

    public static Long anyPositiveLong(long hi) {
        return PrimitiveGenerators.positiveLongs(hi).next();
    }

    public static <T> T anyFixedValue(Collection<T> values) {
        return PrimitiveGenerators.fixedValues(values).next();
    }

    public static <T> T anyFixedValue(T[] values) {
        return PrimitiveGenerators.fixedValues(values).next();
    }

    public static <T> T anyFixedValue(T value) {
        return PrimitiveGenerators.fixedValues(value).next();
    }

    public static <T extends Enum<T>> T anyEnumValue(Class<T> enumClass, Collection<T> excludedCollection) {
        return (T)((Enum)PrimitiveGenerators.enumValues(enumClass, excludedCollection).next());
    }

    public static <T extends Enum<T>> T anyEnumValue(Class<T> enumClass, T[] excluded) {
        return (T)((Enum)PrimitiveGenerators.enumValues(enumClass, excluded).next());
    }

    public static <T extends Enum<T>> T anyEnumValue(Class<T> enumClass) {
        return (T)((Enum)PrimitiveGenerators.enumValues(enumClass).next());
    }
}

