/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.generator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import net.java.quickcheck.ExtendibleGenerator;
import net.java.quickcheck.Generator;
import net.java.quickcheck.ObjectGenerator;
import net.java.quickcheck.generator.distribution.Distribution;
import net.java.quickcheck.generator.support.ByteGenerator;
import net.java.quickcheck.generator.support.CharacterGenerator;
import net.java.quickcheck.generator.support.CloningGenerator;
import net.java.quickcheck.generator.support.DateGenerator;
import net.java.quickcheck.generator.support.DoubleGenerator;
import net.java.quickcheck.generator.support.FixedValuesGenerator;
import net.java.quickcheck.generator.support.IntegerGenerator;
import net.java.quickcheck.generator.support.LongGenerator;
import net.java.quickcheck.generator.support.ObjectDefaultMappingGenerator;
import net.java.quickcheck.generator.support.ObjectGeneratorImpl;
import net.java.quickcheck.generator.support.StringGenerator;

public class PrimitiveGenerators {
    public static ExtendibleGenerator<Character, String> strings() {
        return new StringGenerator();
    }

    public static ExtendibleGenerator<Character, String> strings(char lo, char hi) {
        return new StringGenerator(lo, hi);
    }

    public static ExtendibleGenerator<Character, String> strings(String allowedCharacters) {
        return new StringGenerator(PrimitiveGenerators.characters(allowedCharacters));
    }

    public static ExtendibleGenerator<Character, String> strings(String allowedCharacters, int min, int max) {
        return new StringGenerator(new IntegerGenerator(min, max), PrimitiveGenerators.characters(allowedCharacters));
    }

    public static ExtendibleGenerator<Character, String> strings(int max) {
        return PrimitiveGenerators.strings(0, max);
    }

    public static ExtendibleGenerator<Character, String> strings(int min, int max) {
        return new StringGenerator(new IntegerGenerator(min, max), new CharacterGenerator());
    }

    public static ExtendibleGenerator<Character, String> strings(Generator<Integer> length, Generator<Character> characters) {
        return new StringGenerator(length, characters);
    }

    public static ExtendibleGenerator<Character, String> strings(Generator<Character> characterGenerator) {
        return new StringGenerator(characterGenerator);
    }

    public static ExtendibleGenerator<Character, String> letterStrings() {
        return new StringGenerator(PrimitiveGenerators.characters('a', 'z')).add(PrimitiveGenerators.characters('A', 'Z'));
    }

    public static ExtendibleGenerator<Character, String> letterStrings(int min, int max) {
        StringGenerator generator = new StringGenerator(new IntegerGenerator(min, max), PrimitiveGenerators.characters('a', 'z'));
        return generator.add(PrimitiveGenerators.characters('A', 'Z'));
    }

    public static ExtendibleGenerator<Character, String> printableStrings() {
        return new StringGenerator(PrimitiveGenerators.basicLatinCharacters()).add(PrimitiveGenerators.latin1SupplementCharacters());
    }

    public static ExtendibleGenerator<Character, String> nonEmptyStrings() {
        return PrimitiveGenerators.strings(1, 30);
    }

    public static Generator<Character> characters(char lo, char hi) {
        return new CharacterGenerator(lo, hi);
    }

    public static Generator<Character> characters(Character ... chars) {
        return PrimitiveGenerators.characters((Collection<Character>)Arrays.asList(chars));
    }

    public static Generator<Character> characters(String string) {
        ArrayList<Character> chars = new ArrayList<Character>(string.length());
        int i = 0;
        while (i < string.length()) {
            chars.add(Character.valueOf(string.charAt(i)));
            ++i;
        }
        return PrimitiveGenerators.characters(chars);
    }

    public static Generator<Character> characters(Collection<Character> chars) {
        return new FixedValuesGenerator<Character>(chars);
    }

    public static Generator<Character> latin1SupplementCharacters() {
        return PrimitiveGenerators.characters(CharacterGenerator.LATIN_1_SUPPLEMENT.getFirst().charValue(), CharacterGenerator.LATIN_1_SUPPLEMENT.getSecond().charValue());
    }

    public static Generator<Character> basicLatinCharacters() {
        return PrimitiveGenerators.characters(CharacterGenerator.BASIC_LATIN.getFirst().charValue(), CharacterGenerator.BASIC_LATIN.getSecond().charValue());
    }

    public static Generator<Integer> integers() {
        return new IntegerGenerator();
    }

    public static Generator<Integer> integers(int low) {
        return new IntegerGenerator(low, Integer.MAX_VALUE);
    }

    public static Generator<Integer> integers(int lo, int hi) {
        return new IntegerGenerator(lo, hi);
    }

    public static Generator<Integer> integers(int lo, int hi, Distribution distribution) {
        return new IntegerGenerator(lo, hi, distribution);
    }

    public static Generator<Integer> positiveIntegers() {
        return PrimitiveGenerators.positiveIntegers(Integer.MAX_VALUE);
    }

    public static Generator<Integer> positiveIntegers(int high) {
        return new IntegerGenerator(1, high);
    }

    public static Generator<Byte> bytes() {
        return new ByteGenerator();
    }

    public static Generator<Byte> bytes(byte lo, byte hi) {
        return new ByteGenerator(lo, hi);
    }

    public static Generator<Byte> bytes(byte lo, byte hi, Distribution distribution) {
        return new ByteGenerator(lo, hi, distribution);
    }

    public static Generator<Long> longs() {
        return new LongGenerator();
    }

    public static Generator<Long> longs(long lo, long hi) {
        return new LongGenerator(lo, hi, Distribution.UNIFORM);
    }

    public static Generator<Long> longs(long lo, long hi, Distribution distribution) {
        return new LongGenerator(lo, hi, distribution);
    }

    public static Generator<Long> positiveLongs() {
        return PrimitiveGenerators.positiveLongs(Long.MAX_VALUE);
    }

    public static Generator<Long> positiveLongs(long hi) {
        return PrimitiveGenerators.longs(1L, hi);
    }

    public static Generator<Double> doubles() {
        return new DoubleGenerator();
    }

    public static Generator<Double> doubles(double lo, double hi) {
        return new DoubleGenerator(lo, hi);
    }

    public static Generator<Double> doubles(double lo, double hi, Distribution distribution) {
        return new DoubleGenerator(lo, hi, distribution);
    }

    public static Generator<Boolean> booleans() {
        return new FixedValuesGenerator<Boolean>((Collection)Arrays.asList(Boolean.TRUE, Boolean.FALSE));
    }

    public static <T> Generator<T> nulls() {
        return new FixedValuesGenerator();
    }

    public static Generator<Date> dates() {
        return PrimitiveGenerators.dates(TimeUnit.MILLISECONDS);
    }

    public static Generator<Date> dates(TimeUnit precision) {
        return PrimitiveGenerators.dates(Long.MIN_VALUE, Long.MAX_VALUE, precision);
    }

    public static Generator<Date> dates(Date low, Date high) {
        return PrimitiveGenerators.dates(low.getTime(), high.getTime());
    }

    public static Generator<Date> dates(long low, long high) {
        return PrimitiveGenerators.dates(low, high, TimeUnit.MILLISECONDS);
    }

    public static Generator<Date> dates(Long low, Long high, TimeUnit precision) {
        return new DateGenerator(precision, low, high);
    }

    public static <T> Generator<T> fixedValues(T value) {
        return new FixedValuesGenerator<T>(value);
    }

    public static <T> Generator<T> fixedValues(T ... values) {
        return PrimitiveGenerators.fixedValues((Collection)Arrays.asList(values));
    }

    public static <T> Generator<T> fixedValues(Collection<T> values) {
        return new FixedValuesGenerator<T>(values);
    }

    public static <T> Generator<T> clonedValues(T prototype) {
        return new CloningGenerator<T>(prototype);
    }

    public static <T extends Enum<T>> Generator<T> enumValues(Class<T> enumClass) {
        return PrimitiveGenerators.enumValues(enumClass, Collections.emptyList());
    }

    public static <T extends Enum<T>> Generator<T> enumValues(Class<T> enumClass, T ... excluded) {
        return PrimitiveGenerators.enumValues(enumClass, (Collection)Arrays.asList(excluded));
    }

    public static <T extends Enum<T>> Generator<T> enumValues(Class<T> enumClass, Collection<T> excludedCollection) {
        EnumSet<T> excluded = EnumSet.noneOf(enumClass);
        excluded.addAll(excludedCollection);
        return new FixedValuesGenerator((Collection)EnumSet.complementOf(excluded));
    }

    public static <T> ObjectGenerator<T> objects(Class<T> objectType) {
        return new ObjectGeneratorImpl<T>(objectType);
    }

    public static <T> ObjectGenerator<T> defaultObjects(Class<T> objectType) {
        return new ObjectDefaultMappingGenerator<T>(objectType);
    }
}

