/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.generator;

import java.util.Collection;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import net.java.quickcheck.Generator;
import net.java.quickcheck.generator.PrimitiveGenerators;
import net.java.quickcheck.generator.distribution.Distribution;
import net.java.quickcheck.generator.iterable.Iterables;

public class PrimitiveGeneratorsIterables {
    public static Iterable<Integer> someIntegers() {
        return Iterables.toIterable(PrimitiveGenerators.integers());
    }

    public static Iterable<Integer> someIntegers(int low) {
        return Iterables.toIterable(PrimitiveGenerators.integers(low));
    }

    public static Iterable<Integer> someIntegers(int lo, int hi) {
        return Iterables.toIterable(PrimitiveGenerators.integers(lo, hi));
    }

    public static Iterable<Integer> someIntegers(int lo, int hi, Distribution distribution) {
        return Iterables.toIterable(PrimitiveGenerators.integers(lo, hi, distribution));
    }

    public static Iterable<Integer> somePositiveIntegers() {
        return Iterables.toIterable(PrimitiveGenerators.positiveIntegers());
    }

    public static Iterable<Integer> somePositiveIntegers(int high) {
        return Iterables.toIterable(PrimitiveGenerators.positiveIntegers(high));
    }

    public static <T> Iterable<T> someNulls() {
        return Iterables.toIterable(PrimitiveGenerators.nulls());
    }

    public static Iterable<Long> someLongs() {
        return Iterables.toIterable(PrimitiveGenerators.longs());
    }

    public static Iterable<Long> someLongs(long lo, long hi) {
        return Iterables.toIterable(PrimitiveGenerators.longs(lo, hi));
    }

    public static Iterable<Long> someLongs(long lo, long hi, Distribution distribution) {
        return Iterables.toIterable(PrimitiveGenerators.longs(lo, hi, distribution));
    }

    public static <T> Iterable<T> someObjects(Class<T> objectType) {
        return Iterables.toIterable(PrimitiveGenerators.objects(objectType));
    }

    public static <T> Iterable<T> someClonedValues(T prototype) {
        return Iterables.toIterable(PrimitiveGenerators.clonedValues(prototype));
    }

    public static Iterable<Boolean> someBooleans() {
        return Iterables.toIterable(PrimitiveGenerators.booleans());
    }

    public static Iterable<String> someLetterStrings() {
        return Iterables.toIterable(PrimitiveGenerators.letterStrings());
    }

    public static Iterable<String> someLetterStrings(int min, int max) {
        return Iterables.toIterable(PrimitiveGenerators.letterStrings(min, max));
    }

    public static <T> Iterable<T> someDefaultObjects(Class<T> objectType) {
        return Iterables.toIterable(PrimitiveGenerators.defaultObjects(objectType));
    }

    public static Iterable<Character> someCharacters(char lo, char hi) {
        return Iterables.toIterable(PrimitiveGenerators.characters(lo, hi));
    }

    public static Iterable<Character> someCharacters(Character[] chars) {
        return Iterables.toIterable(PrimitiveGenerators.characters(chars));
    }

    public static Iterable<Character> someCharacters(String string) {
        return Iterables.toIterable(PrimitiveGenerators.characters(string));
    }

    public static Iterable<Character> someCharacters(Collection<Character> chars) {
        return Iterables.toIterable(PrimitiveGenerators.characters(chars));
    }

    public static Iterable<Byte> someBytes() {
        return Iterables.toIterable(PrimitiveGenerators.bytes());
    }

    public static Iterable<Byte> someBytes(byte lo, byte hi) {
        return Iterables.toIterable(PrimitiveGenerators.bytes(lo, hi));
    }

    public static Iterable<Byte> someBytes(byte lo, byte hi, Distribution distribution) {
        return Iterables.toIterable(PrimitiveGenerators.bytes(lo, hi, distribution));
    }

    public static Iterable<String> someStrings(Generator<Character> characterGenerator) {
        return Iterables.toIterable(PrimitiveGenerators.strings(characterGenerator));
    }

    public static Iterable<String> someStrings(Generator<Integer> length, Generator<Character> characters) {
        return Iterables.toIterable(PrimitiveGenerators.strings(length, characters));
    }

    public static Iterable<String> someStrings() {
        return Iterables.toIterable(PrimitiveGenerators.strings());
    }

    public static Iterable<String> someStrings(char lo, char hi) {
        return Iterables.toIterable(PrimitiveGenerators.strings(lo, hi));
    }

    public static Iterable<String> someStrings(String allowedCharacters) {
        return Iterables.toIterable(PrimitiveGenerators.strings(allowedCharacters));
    }

    public static Iterable<String> someStrings(String allowedCharacters, int min, int max) {
        return Iterables.toIterable(PrimitiveGenerators.strings(allowedCharacters, min, max));
    }

    public static Iterable<String> someStrings(int max) {
        return Iterables.toIterable(PrimitiveGenerators.strings(max));
    }

    public static Iterable<String> someStrings(int min, int max) {
        return Iterables.toIterable(PrimitiveGenerators.strings(min, max));
    }

    public static Iterable<Character> someBasicLatinCharacters() {
        return Iterables.toIterable(PrimitiveGenerators.basicLatinCharacters());
    }

    public static Iterable<String> somePrintableStrings() {
        return Iterables.toIterable(PrimitiveGenerators.printableStrings());
    }

    public static Iterable<Date> someDates(Long low, Long high, TimeUnit precision) {
        return Iterables.toIterable(PrimitiveGenerators.dates(low, high, precision));
    }

    public static Iterable<Date> someDates(long low, long high) {
        return Iterables.toIterable(PrimitiveGenerators.dates(low, high));
    }

    public static Iterable<Date> someDates() {
        return Iterables.toIterable(PrimitiveGenerators.dates());
    }

    public static Iterable<Date> someDates(TimeUnit precision) {
        return Iterables.toIterable(PrimitiveGenerators.dates(precision));
    }

    public static Iterable<Date> someDates(Date low, Date high) {
        return Iterables.toIterable(PrimitiveGenerators.dates(low, high));
    }

    public static Iterable<Double> someDoubles(double lo, double hi, Distribution distribution) {
        return Iterables.toIterable(PrimitiveGenerators.doubles(lo, hi, distribution));
    }

    public static Iterable<Double> someDoubles(double lo, double hi) {
        return Iterables.toIterable(PrimitiveGenerators.doubles(lo, hi));
    }

    public static Iterable<Double> someDoubles() {
        return Iterables.toIterable(PrimitiveGenerators.doubles());
    }

    public static Iterable<Character> someLatin1SupplementCharacters() {
        return Iterables.toIterable(PrimitiveGenerators.latin1SupplementCharacters());
    }

    public static Iterable<String> someNonEmptyStrings() {
        return Iterables.toIterable(PrimitiveGenerators.nonEmptyStrings());
    }

    public static Iterable<Long> somePositiveLongs() {
        return Iterables.toIterable(PrimitiveGenerators.positiveLongs());
    }

    public static Iterable<Long> somePositiveLongs(long hi) {
        return Iterables.toIterable(PrimitiveGenerators.positiveLongs(hi));
    }

    public static <T> Iterable<T> someFixedValues(Collection<T> values) {
        return Iterables.toIterable(PrimitiveGenerators.fixedValues(values));
    }

    public static <T> Iterable<T> someFixedValues(T[] values) {
        return Iterables.toIterable(PrimitiveGenerators.fixedValues(values));
    }

    public static <T> Iterable<T> someFixedValues(T value) {
        return Iterables.toIterable(PrimitiveGenerators.fixedValues(value));
    }

    public static <T extends Enum<T>> Iterable<T> someEnumValues(Class<T> enumClass, Collection<T> excludedCollection) {
        return Iterables.toIterable(PrimitiveGenerators.enumValues(enumClass, excludedCollection));
    }

    public static <T extends Enum<T>> Iterable<T> someEnumValues(Class<T> enumClass, T[] excluded) {
        return Iterables.toIterable(PrimitiveGenerators.enumValues(enumClass, excluded));
    }

    public static <T extends Enum<T>> Iterable<T> someEnumValues(Class<T> enumClass) {
        return Iterables.toIterable(PrimitiveGenerators.enumValues(enumClass));
    }
}

