/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.generator.distribution;

import java.util.Random;

public interface Distribution {
    public static final Distribution POSITIV_NORMAL = new AbstractDistribution(){

        @Override
        public double nextRandomNumber() {
            return Math.abs(this.nextGausian());
        }
    };
    public static final Distribution NEGATIV_NORMAL = new AbstractDistribution(){

        @Override
        public double nextRandomNumber() {
            return Math.abs(-1.0 + Math.abs(this.nextGausian()));
        }
    };
    public static final Distribution INVERTED_NORMAL = new AbstractDistribution(){

        @Override
        public double nextRandomNumber() {
            double next = this.nextGausian(6);
            return next < 0.0 ? 1.0 + next : next;
        }
    };
    public static final Distribution UNIFORM = new AbstractDistribution(){

        @Override
        public double nextRandomNumber() {
            return this.random.nextDouble();
        }
    };

    public double nextRandomNumber();

    public static abstract class AbstractDistribution
    implements Distribution {
        final Random random = new Random();
        static final int N_SIGMA = 3;

        AbstractDistribution() {
        }

        @Override
        public abstract double nextRandomNumber();

        double nextGausian() {
            return this.nextGausian(3);
        }

        double nextGausian(int sigma) {
            return this.random.nextGaussian() % (double)sigma / (double)sigma;
        }
    }
}

