/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.generator.iterable;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.java.quickcheck.Generator;
import net.java.quickcheck.util.Assert;

public final class Iterables {
    private Iterables() {
    }

    public static <T> Iterable<T> toIterable(final Generator<T> generator) {
        Assert.notNull(generator, "generator");
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    private int runs;

                    @Override
                    public boolean hasNext() {
                        return this.runs < 200;
                    }

                    @Override
                    public T next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        ++this.runs;
                        return generator.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

