/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.generator.support;

import java.math.BigDecimal;
import net.java.quickcheck.Generator;
import net.java.quickcheck.generator.distribution.Distribution;
import net.java.quickcheck.util.Assert;

abstract class AbstractNumberGenerator<T>
implements Generator<T> {
    private final Distribution distribution;
    private final long min;
    private final long max;
    private final long range;

    AbstractNumberGenerator(long min, long max, Distribution dist) {
        Assert.lessOrEqual(max, min, "min <= max");
        this.min = min;
        this.max = max;
        this.range = max - min;
        this.distribution = dist;
    }

    long nextLong() {
        return this.isLongOverflow() ? this.bigDecimalImpl() : this.longImpl();
    }

    private boolean isLongOverflow() {
        return this.range < 0L;
    }

    private long longImpl() {
        return this.min + (long)Math.floor(this.distribution.nextRandomNumber() * ((double)this.range + 1.0));
    }

    private long bigDecimalImpl() {
        BigDecimal range = BigDecimal.valueOf(this.max).add(BigDecimal.valueOf(1L)).subtract(BigDecimal.valueOf(this.min));
        return BigDecimal.valueOf(this.min).add(BigDecimal.valueOf(this.distribution.nextRandomNumber()).multiply(range)).setScale(0, 3).longValue();
    }
}

