/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.generator.support;

import java.lang.reflect.Array;
import net.java.quickcheck.Generator;
import net.java.quickcheck.generator.support.AbstractTransformerGenerator;

abstract class AbstractPrimitiveArrayGenerator<I, P>
extends AbstractTransformerGenerator<I, P> {
    private Class<?> componentType;

    AbstractPrimitiveArrayGenerator(Generator<I> inputGenerator, Class<?> componentType) {
        super(inputGenerator);
        this.componentType = componentType;
    }

    @Override
    protected P transform(Generator<I> inputGenerator) {
        I objectArray = inputGenerator.next();
        P primitive = this.createPrimitiveArray(objectArray);
        int i = 0;
        while (i < Array.getLength(objectArray)) {
            Array.set(primitive, i, Array.get(objectArray, i));
            ++i;
        }
        return primitive;
    }

    private P createPrimitiveArray(I objectArray) {
        return (P)Array.newInstance(this.componentType, Array.getLength(objectArray));
    }
}

