/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.generator.support;

import java.util.ArrayList;
import java.util.List;
import net.java.quickcheck.Generator;
import net.java.quickcheck.GeneratorException;

public abstract class AbstractTreeGenerator<T>
implements Generator<T> {
    public static final int MAX_TREE_DEPTH = 50;

    protected abstract T createNode();

    protected abstract void addChildren(T var1, List<T> var2);

    protected abstract int getChildCount(int var1, int var2);

    @Override
    public T next() {
        return this.createNodeAndAddChildren(-1, 1);
    }

    private List<T> down(int level, int numberOfSiblings) {
        this.checkDepth(level);
        ArrayList<T> result = new ArrayList<T>();
        int childCount = this.getChildCount(level, numberOfSiblings);
        int i = 0;
        while (i < childCount) {
            T node = this.createNodeAndAddChildren(level, childCount);
            result.add(node);
            ++i;
        }
        return result;
    }

    private void checkDepth(int level) {
        if (level > 50) {
            throw new GeneratorException(String.format("Max tree depth (%s) exceeded.", 50), this);
        }
    }

    private T createNodeAndAddChildren(int level, int numberOfSiblings) {
        T node = this.createNode();
        this.addChildren(node, this.down(level + 1, numberOfSiblings));
        return node;
    }
}

