/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.generator.support;

import java.lang.reflect.Array;
import java.util.List;
import net.java.quickcheck.Generator;
import net.java.quickcheck.generator.support.AbstractTransformerGenerator;
import net.java.quickcheck.generator.support.ListGenerator;
import net.java.quickcheck.util.Assert;

public class ArrayGenerator<T>
extends AbstractTransformerGenerator<List<T>, T[]> {
    public static final int MAX_SIZE = 10;
    public static final int MIN_SIZE = 0;
    private T[] emptyArrayOfT;

    public ArrayGenerator(Generator<T> content, Class<T> type) {
        super(new ListGenerator<T>(content));
        this.setEmptyArrayOfT(type);
    }

    public ArrayGenerator(Generator<T> content, Generator<Integer> size, Class<T> type) {
        super(new ListGenerator<T>(content, size));
        this.setEmptyArrayOfT(type);
    }

    private void setEmptyArrayOfT(Class<T> type) {
        Assert.notNull(type, "content type");
        this.emptyArrayOfT = this.emptyArrayOfT(type);
    }

    @Override
    protected T[] transform(Generator<List<T>> inputGenerator) {
        return inputGenerator.next().toArray(this.emptyArrayOfT);
    }

    private T[] emptyArrayOfT(Class<T> type) {
        return (Object[])Array.newInstance(type, 0);
    }
}

