/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.generator.support;

import net.java.quickcheck.Generator;
import net.java.quickcheck.collection.Pair;
import net.java.quickcheck.generator.support.IntegerGenerator;
import net.java.quickcheck.util.Assert;

public class CharacterGenerator
implements Generator<Character> {
    public static final Pair<Character, Character> BASIC_LATIN = new Pair<Character, Character>(Character.valueOf(' '), Character.valueOf('\u007f'));
    public static final Pair<Character, Character> LATIN_1_SUPPLEMENT = new Pair<Character, Character>(Character.valueOf('\u00a0'), Character.valueOf('\u00ff'));
    private final IntegerGenerator generator;

    public CharacterGenerator() {
        this(BASIC_LATIN.getFirst().charValue(), BASIC_LATIN.getSecond().charValue());
    }

    public CharacterGenerator(char first, char last) {
        Assert.lessOrEqual(last, first, "first <= last");
        this.generator = new IntegerGenerator(first, last);
    }

    @Override
    public Character next() {
        return Character.valueOf(this.nextChar());
    }

    public char nextChar() {
        return (char)this.generator.nextInt();
    }
}

