/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.generator.support;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.java.quickcheck.Generator;

public class CloningGenerator<T>
implements Generator<T> {
    private T fPrototype;

    public CloningGenerator(T prototype) {
        this.fPrototype = prototype;
    }

    @Override
    public T next() {
        try {
            return this.cloneObject();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("prototype " + this.fPrototype + " not serializable.", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("this should not happen " + e.getMessage(), e);
        }
    }

    private T cloneObject() throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bytesStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(bytesStream);
        objectOutputStream.writeObject(this.fPrototype);
        objectOutputStream.flush();
        objectOutputStream.close();
        ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(bytesStream.toByteArray()));
        return this.castObjectToT(objectInputStream);
    }

    private T castObjectToT(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        return (T)objectInputStream.readObject();
    }
}

