/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.generator.support;

import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import net.java.quickcheck.Generator;
import net.java.quickcheck.generator.support.LongGenerator;
import net.java.quickcheck.generator.support.VetoableGenerator;

public class DateGenerator
implements Generator<Date> {
    private VetoableGenerator<Long> generator;

    public DateGenerator(TimeUnit precision, long low, long high) {
        this.generator = new VetoableGenerator<Long>((Generator)new MillisGenerator(precision, low, high)){

            @Override
            protected boolean tryValue(Long value) {
                return value != null;
            }
        };
    }

    @Override
    public Date next() {
        return new Date(this.generator.next());
    }

    private static Calendar calendar(long millis) {
        Calendar time = Calendar.getInstance();
        time.setTimeInMillis(millis);
        return time;
    }

    private static class MillisGenerator
    implements Generator<Long> {
        private final long precision;
        private final LongGenerator times;
        private final long low;
        private final long high;
        private static final long TIME_ZONE_OFFSET = TimeUnit.HOURS.toMillis(DateGenerator.access$1(0L).get(10));

        public MillisGenerator(TimeUnit precision, long low, long high) {
            this.precision = precision.toMillis(1L);
            this.times = new LongGenerator(low, high);
            this.low = low;
            this.high = high;
        }

        @Override
        public Long next() {
            long offset;
            long millis = this.times.next() / this.precision * this.precision;
            long correctedMillis = millis - (offset = (long)this.daylightSavingOffset(millis) + TIME_ZONE_OFFSET);
            return this.isOutOffBounds(correctedMillis) || this.isOverflow(millis, correctedMillis) ? null : Long.valueOf(correctedMillis);
        }

        private boolean isOutOffBounds(long correctedMillis) {
            return correctedMillis < this.low || correctedMillis > this.high;
        }

        private boolean isOverflow(long millis, long correctedMillis) {
            return Math.signum(correctedMillis) != Math.signum(millis);
        }

        private int daylightSavingOffset(long millis) {
            return DateGenerator.calendar(millis).get(16);
        }

        public String toString() {
            return String.format("%s[low=%s, high=%s, precision=%s", this.getClass().getSimpleName(), this.low, this.high, this.precision);
        }
    }
}

