/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.generator.support;

import net.java.quickcheck.Generator;
import net.java.quickcheck.generator.distribution.Distribution;
import net.java.quickcheck.util.Assert;

public class DoubleGenerator
implements Generator<Double> {
    private final double min;
    private final double max;
    private final Distribution distribution;

    public DoubleGenerator() {
        this(Double.MIN_VALUE, Double.MAX_VALUE);
    }

    public DoubleGenerator(double min, double max) {
        this(min, max, Distribution.UNIFORM);
    }

    public DoubleGenerator(double min, double max, Distribution dist) {
        Assert.lessOrEqual(max, min, "min");
        Assert.notNull(dist, "dist");
        this.min = min;
        this.max = max;
        this.distribution = dist;
    }

    @Override
    public Double next() {
        return this.nextDouble();
    }

    public double nextDouble() {
        return this.distribution.nextRandomNumber() * (this.max - this.min) + this.min;
    }

    public String toString() {
        return String.format("%s[min=%s, max=%s, distribution=%s", this.getClass().getSimpleName(), this.min, this.max, this.distribution);
    }
}

