/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.generator.support;

import java.util.Collection;
import java.util.Iterator;
import net.java.quickcheck.Generator;
import net.java.quickcheck.StatefulGenerator;
import net.java.quickcheck.generator.support.FixedValuesGenerator;
import net.java.quickcheck.util.Assert;

public class EnsuredValuesGenerator<T>
implements StatefulGenerator<T> {
    private final Collection<T> ensured;
    private final Generator<T> generator;
    private Iterator<T> iterator;

    public EnsuredValuesGenerator(Collection<T> values) {
        this(values, new FixedValuesGenerator<T>(values));
    }

    public EnsuredValuesGenerator(Collection<T> ensured, Generator<T> random) {
        Assert.notNull(ensured, "ensured");
        Assert.notEmpty(ensured, "ensured");
        Assert.notNull(random, "random");
        this.ensured = ensured;
        this.generator = random;
        this.reset();
    }

    @Override
    public T next() {
        return this.iterator.hasNext() ? this.iterator.next() : this.generator.next();
    }

    @Override
    public void reset() {
        this.iterator = this.ensured.iterator();
    }
}

