/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.generator.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.java.quickcheck.Generator;
import net.java.quickcheck.generator.support.IntegerGenerator;
import net.java.quickcheck.util.Assert;

public class FixedValuesGenerator<T>
implements Generator<T> {
    private final List<T> values;
    private final IntegerGenerator index;

    public FixedValuesGenerator() {
        this((Collection)Collections.singleton(null));
    }

    public FixedValuesGenerator(T value) {
        this((Collection)Collections.singleton(value));
    }

    public FixedValuesGenerator(Collection<T> values) {
        Assert.notNull(values, "values");
        Assert.notEmpty(values, "values");
        this.values = new ArrayList<T>(values);
        this.index = new IntegerGenerator(0, this.values.size() - 1);
    }

    @Override
    public T next() {
        return this.values.get(this.index.nextInt());
    }
}

