/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.generator.support;

import java.util.Iterator;
import net.java.quickcheck.Generator;
import net.java.quickcheck.generator.support.IntegerGenerator;
import net.java.quickcheck.util.Assert;

public class IteratorGenerator<T>
implements Generator<Iterator<T>> {
    public static final int MIN_SIZE = 0;
    public static final int MAX_SIZE = 10;
    private final Generator<T> content;
    private final Generator<Integer> size;

    public IteratorGenerator(Generator<T> content) {
        this(content, 0, 10);
    }

    public IteratorGenerator(Generator<T> content, int min, int max) {
        this(content, new IntegerGenerator(min, max));
    }

    public IteratorGenerator(Generator<T> content, Generator<Integer> size) {
        Assert.notNull(content, "content");
        Assert.notNull(size, "size");
        this.content = content;
        this.size = size;
    }

    @Override
    public Iterator<T> next() {
        final int size = Math.max(0, this.size.next());
        return new Iterator<T>(){
            private int i;

            @Override
            public boolean hasNext() {
                return this.i < size;
            }

            @Override
            public T next() {
                ++this.i;
                return IteratorGenerator.this.content.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove not supported.");
            }
        };
    }
}

