/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.generator.support;

import java.util.ArrayList;
import java.util.List;
import net.java.quickcheck.Generator;
import net.java.quickcheck.generator.support.IntegerGenerator;
import net.java.quickcheck.util.Assert;

public class ListGenerator<T>
implements Generator<List<T>> {
    public static final int MIN_SIZE = 0;
    public static final int MAX_SIZE = 10;
    private final Generator<T> content;
    private final Generator<Integer> size;

    public ListGenerator(Generator<T> content) {
        this(content, 0, 10);
    }

    public ListGenerator(Generator<T> content, int min, int max) {
        this(content, new IntegerGenerator(min, max));
    }

    public ListGenerator(Generator<T> content, Generator<Integer> size) {
        Assert.notNull(content, "content");
        Assert.notNull(size, "size");
        this.content = content;
        this.size = size;
    }

    @Override
    public List<T> next() {
        int size = Math.max(0, this.size.next());
        ArrayList<T> list = new ArrayList<T>(size);
        int i = 0;
        while (i < size) {
            list.add(this.content.next());
            ++i;
        }
        return list;
    }
}

