/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.generator.support;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.java.quickcheck.Generator;
import net.java.quickcheck.generator.support.ByteGenerator;
import net.java.quickcheck.generator.support.DoubleGenerator;
import net.java.quickcheck.generator.support.IntegerGenerator;
import net.java.quickcheck.generator.support.LongGenerator;
import net.java.quickcheck.generator.support.ObjectGeneratorImpl;
import net.java.quickcheck.generator.support.StringGenerator;

public class ObjectDefaultMappingGenerator<T>
extends ObjectGeneratorImpl<T> {
    private static final Map<Class<?>, Generator<?>> RETURN_TYPE_TO_GENERATOR = new HashMap();

    static {
        ObjectDefaultMappingGenerator.map(new IntegerGenerator(), Integer.class, Integer.TYPE);
        ObjectDefaultMappingGenerator.map(new StringGenerator(), String.class);
        ObjectDefaultMappingGenerator.map(new LongGenerator(), Long.class, Long.TYPE);
        ObjectDefaultMappingGenerator.map(new DoubleGenerator(), Double.class, Double.TYPE, Number.class);
        ObjectDefaultMappingGenerator.map(new ByteGenerator(), Byte.TYPE, Byte.class);
    }

    public ObjectDefaultMappingGenerator(Class<T> objectType) {
        super(objectType);
        this.mapMethodsToGenerators();
    }

    private static void map(Generator<?> generator, Class<?> ... classes) {
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            RETURN_TYPE_TO_GENERATOR.put(c, generator);
            ++n2;
        }
    }

    private void mapMethodsToGenerators() {
        Method[] methodArray = this.definition.getType().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Class<?> returnType = method.getReturnType();
            Generator generator = RETURN_TYPE_TO_GENERATOR.get(returnType);
            if (generator == null && returnType.isInterface()) {
                generator = this.buildGenerator(returnType);
            }
            this.definition.defineMapping(method, generator);
            ++n2;
        }
    }

    private <R> ObjectDefaultMappingGenerator<R> buildGenerator(Class<R> returnType) {
        return new ObjectDefaultMappingGenerator<R>(returnType);
    }
}

