/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.generator.support;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import net.java.quickcheck.Generator;
import net.java.quickcheck.ObjectGenerator;

class ObjectDefinition<T>
implements InvocationHandler {
    private final Map<Method, Generator<?>> methodsGeneratorMapping = new HashMap();
    private final T targetMethodRecorder;
    private Method calledTargetMethod;
    private Class<T> type;

    public ObjectDefinition(Class<T> objectType) {
        this.checkIsInterface(objectType);
        this.type = objectType;
        this.targetMethodRecorder = this.createTargetMethodRecorder(objectType);
    }

    public T getRecorder() {
        return this.targetMethodRecorder;
    }

    public <R> ObjectGenerator.ReturnValue<R> onMethod(R obj) {
        final Method currentCalled = this.currentCalledMethod();
        return new ObjectGenerator.ReturnValue<R>(){

            @Override
            public void returns(Generator<? extends R> generator) {
                ObjectDefinition.this.defineMapping(currentCalled, generator);
            }
        };
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        assert (args == null);
        this.calledTargetMethod = method;
        return null;
    }

    private Method currentCalledMethod() {
        if (this.calledTargetMethod == null) {
            throw new IllegalStateException("Has to be called with recorder instance.");
        }
        Method currentCalled = this.calledTargetMethod;
        this.calledTargetMethod = null;
        return currentCalled;
    }

    private T createTargetMethodRecorder(Class<T> type) {
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{type}, (InvocationHandler)this);
    }

    private void checkIsInterface(Class<T> objectType) {
        if (!objectType.isInterface()) {
            String message = String.format("Only interfaces supported (class: %s).", objectType.getName());
            throw new IllegalArgumentException(message);
        }
    }

    public Class<T> getType() {
        return this.type;
    }

    public void defineMapping(Method method, Generator<?> generator) {
        this.methodsGeneratorMapping.put(method, generator);
    }

    public Generator<?> retrieveMapping(Method method) {
        return this.methodsGeneratorMapping.get(method);
    }
}

