/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.generator.support;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.java.quickcheck.generator.support.ObjectDefinition;

class ObjectFactory<T>
implements InvocationHandler {
    private final ObjectDefinition<T> definition;

    public ObjectFactory(ObjectDefinition<T> definition) {
        this.definition = definition;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return this.definition.retrieveMapping(method).next();
    }

    private void checkAllMethodsAreDefined() {
        Method[] methodArray = this.definition.getType().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (!method.getReturnType().equals(Void.TYPE) && this.definition.retrieveMapping(method) == null) {
                String message = String.format("Definition for method %s missing.", method.getName());
                throw new IllegalStateException(message);
            }
            ++n2;
        }
    }

    public T newValue() {
        this.checkAllMethodsAreDefined();
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.definition.getType()}, (InvocationHandler)this);
    }
}

