/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.generator.support;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.java.quickcheck.Generator;
import net.java.quickcheck.StatefulGenerator;
import net.java.quickcheck.generator.support.IntegerGenerator;
import net.java.quickcheck.generator.support.ListGenerator;
import net.java.quickcheck.generator.support.UniqueValuesGenerator;

public class SetGenerator<T>
implements Generator<Set<T>> {
    public static final int MAX_SIZE = 10;
    private ListGenerator<T> lists;
    private StatefulGenerator<T> content;

    public SetGenerator(Generator<T> content) {
        this(content, new IntegerGenerator(0, 10));
    }

    public SetGenerator(Generator<T> content, Generator<Integer> size) {
        this.content = new UniqueValuesGenerator<T>(content);
        this.lists = new ListGenerator<T>(this.content, size);
    }

    @Override
    public Set<T> next() {
        this.content.reset();
        return new HashSet((Collection)this.lists.next());
    }
}

