/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.generator.support;

import net.java.quickcheck.ExtendibleGenerator;
import net.java.quickcheck.FrequencyGenerator;
import net.java.quickcheck.Generator;
import net.java.quickcheck.generator.support.CharacterGenerator;
import net.java.quickcheck.generator.support.DefaultFrequencyGenerator;
import net.java.quickcheck.generator.support.IntegerGenerator;
import net.java.quickcheck.util.Assert;

public class StringGenerator
implements ExtendibleGenerator<Character, String> {
    public static final int MIN_LENGTH = 0;
    public static final int MAX_LENGTH = 30;
    private final FrequencyGenerator<Character> characters;
    private final Generator<Integer> length;

    public StringGenerator() {
        this(new CharacterGenerator());
    }

    public StringGenerator(char first, char last) {
        this(new CharacterGenerator(first, last));
    }

    public StringGenerator(Generator<Character> characters) {
        this(new IntegerGenerator(0, 30), characters);
    }

    public StringGenerator(Generator<Integer> length, Generator<Character> characters) {
        Assert.notNull(length, "length");
        this.length = length;
        this.characters = new DefaultFrequencyGenerator<Character>(characters);
    }

    @Override
    public String next() {
        int size = this.length.next();
        StringBuilder builder = new StringBuilder();
        int count = 0;
        while (count < size) {
            builder.append(this.characters.next());
            ++count;
        }
        return builder.toString();
    }

    @Override
    public ExtendibleGenerator<Character, String> add(Generator<Character> characterGenerator) {
        this.characters.add(characterGenerator);
        return this;
    }
}

