/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.generator.support;

import net.java.quickcheck.Generator;
import net.java.quickcheck.GeneratorException;
import net.java.quickcheck.util.Assert;

public abstract class VetoableGenerator<T>
implements Generator<T> {
    private final Generator<T> generator;
    private final int maxTries;
    public static final int DEFAULT_MAX_TRIES = 100;
    public static final int MIN_TRIES = 1;

    public VetoableGenerator(Generator<T> generator) {
        this(generator, 100);
    }

    public VetoableGenerator(Generator<T> generator, int maxTries) {
        Assert.greaterOrEqual(1.0, maxTries, "maxTries");
        this.generator = generator;
        this.maxTries = maxTries;
    }

    @Override
    public T next() throws GeneratorException {
        int idx = 0;
        while (idx < this.maxTries) {
            T value = this.generator.next();
            if (this.tryValue(value)) {
                return value;
            }
            ++idx;
        }
        throw new GeneratorException(String.format("Failed to generate another value after [%s] tries (generator: %s)", this.maxTries, this.generator), this.generator);
    }

    protected abstract boolean tryValue(T var1);
}

