/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.junit.support;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.java.quickcheck.Generator;
import net.java.quickcheck.collection.Pair;
import net.java.quickcheck.junit.ForAll;

public class Discovery {
    private static final String DOT_STRING = ".";

    private static List<Method> getMethods(Class<?> clazz, Predicate predicate) {
        Method[] declaredMethods;
        ArrayList<Method> characteristicMethods = new ArrayList<Method>();
        Method[] methodArray = declaredMethods = clazz.getDeclaredMethods();
        int n = declaredMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (predicate.evaluate(method)) {
                characteristicMethods.add(method);
            }
            ++n2;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            characteristicMethods.addAll(Discovery.getMethods(superclass, predicate));
        }
        return characteristicMethods;
    }

    static List<Method> discoverGeneratorMethods(Class<?> clazz) {
        return Discovery.getMethods(clazz, new Predicate(){

            @Override
            public boolean evaluate(Method method) {
                return Generator.class.isAssignableFrom(method.getReturnType()) && method.getParameterTypes().length == 0;
            }
        });
    }

    public static List<Method> getGeneratorMethods(Class<?> testClazz, String[] generatorNames) {
        ArrayList<Method> matchingMethods = new ArrayList<Method>();
        String[] stringArray = generatorNames;
        int n = generatorNames.length;
        int n2 = 0;
        while (n2 < n) {
            String generatorName = stringArray[n2];
            Discovery.getGeneratorMethods(matchingMethods, testClazz, generatorName);
            ++n2;
        }
        if (matchingMethods.size() > 0) {
            return matchingMethods;
        }
        if (Discovery.discoverGeneratorMethods(testClazz).size() == 1 && generatorNames.length == 1 && "__NO_GENERATOR__".equals(generatorNames[0])) {
            return Collections.singletonList(Discovery.discoverGeneratorMethods(testClazz).get(0));
        }
        throw new IllegalArgumentException(String.format("generator methods (%s) not found ", Arrays.toString(generatorNames)));
    }

    private static void getGeneratorMethods(List<Method> matchingMethods, Class<?> testClazz, String generatorName) {
        Pair<Class<?>, String> classAndMethod = Discovery.discoverForGeneratorMethod(testClazz, generatorName);
        for (Method method : Discovery.discoverGeneratorMethods(classAndMethod.getFirst())) {
            if (!method.getName().equals(classAndMethod.getSecond())) continue;
            matchingMethods.add(method);
        }
    }

    private static Pair<Class<?>, String> discoverForGeneratorMethod(Class<?> testClazz, String generatorName) {
        if (Discovery.isStaticGeneratorMethod(generatorName)) {
            int lastDot = generatorName.lastIndexOf(DOT_STRING);
            String usedMethod = generatorName.substring(lastDot + 1);
            String className = generatorName.substring(0, lastDot);
            return new Pair(Discovery.loadClass(className), usedMethod);
        }
        return new Pair(testClazz, generatorName);
    }

    private static Class<?> loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isStaticGeneratorMethod(String generatorName) {
        return generatorName.contains(DOT_STRING);
    }

    public static List<Method> getCharacteristicMethods(Class<?> testClass) {
        return Discovery.getMethods(testClass, new Predicate(){

            @Override
            public boolean evaluate(Method method) {
                return method.isAnnotationPresent(ForAll.class);
            }
        });
    }

    public static boolean isGeneratorMethodAnnotation(ForAll annotation) {
        return Arrays.equals(new Class[]{ForAll.NoGenerator.class}, annotation.generatorClass());
    }

    private static interface Predicate {
        public boolean evaluate(Method var1);
    }
}

