/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.junit.support;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.java.quickcheck.Generator;
import net.java.quickcheck.junit.ForAll;
import net.java.quickcheck.junit.support.Discovery;

public class GeneratorFactory {
    public static List<Generator<Object>> createGenerator(Object testClassInstance, ForAll annotation) {
        if (Discovery.isGeneratorMethodAnnotation(annotation)) {
            return GeneratorFactory.createGeneratorFromMethod(testClassInstance, annotation);
        }
        return GeneratorFactory.createGeneratorFromClass(annotation.generatorClass());
    }

    private static List<Generator<Object>> createGeneratorFromMethod(Object testClassInstance, ForAll annotation) {
        List<Method> generatorMethods = Discovery.getGeneratorMethods(testClassInstance.getClass(), annotation.generatorMethod());
        ArrayList<Generator<Object>> generators = new ArrayList<Generator<Object>>();
        for (Method generatorMethod : generatorMethods) {
            try {
                generators.add((Generator)generatorMethod.invoke(testClassInstance, new Object[0]));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return generators;
    }

    private static List<Generator<Object>> createGeneratorFromClass(Class<?>[] generatorClasses) {
        ArrayList<Generator<Object>> gens = new ArrayList<Generator<Object>>();
        Class<?>[] classArray = generatorClasses;
        int n = generatorClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> generatorClass = classArray[n2];
            gens.add((Generator)GeneratorFactory.newInstance(generatorClass));
            ++n2;
        }
        return gens;
    }

    public static Object newInstance(Class<?> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

