/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.junit3;

import java.lang.reflect.Method;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import net.java.quickcheck.generator.support.RoundRobinGenerator;
import net.java.quickcheck.junit.ForAll;
import net.java.quickcheck.junit.support.Discovery;
import net.java.quickcheck.junit.support.GeneratorFactory;
import net.java.quickcheck.junit3.CharacteristicsTester;

public class CharacteristicsTestSuiteBuilder {
    public static Test buildSuite(Class<?> testClass) {
        List<Method> characteristicMethods = Discovery.getCharacteristicMethods(testClass);
        TestSuite suite = new TestSuite();
        for (Method characteristicMethod : characteristicMethods) {
            CharacteristicsTestSuiteBuilder.addTesters(suite, testClass, characteristicMethod);
        }
        return suite;
    }

    private static void addTesters(TestSuite suite, Class<?> testClass, Method characteristicMethod) {
        ForAll annotation = characteristicMethod.getAnnotation(ForAll.class);
        Object testClassInstance = GeneratorFactory.newInstance(testClass);
        suite.addTest((Test)new CharacteristicsTester(testClassInstance, new RoundRobinGenerator<Object>(GeneratorFactory.createGenerator(testClassInstance, annotation)), characteristicMethod, annotation.runs(), annotation.verbose()));
    }
}

