/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.junit3;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import junit.framework.TestCase;
import net.java.quickcheck.Characteristic;
import net.java.quickcheck.Generator;
import net.java.quickcheck.RunnerFactory;

class CharacteristicsTester
extends TestCase {
    private final Method fMethod;
    private final Object fInstance;
    private final int fRuns;
    private final boolean fVerbose;
    private final Generator<Object> fGenerator;
    private final Method fSetupMethod;
    private final Method fTearDownMethod;

    CharacteristicsTester(Object testClassInstance, Generator<Object> generator, Method method, int runs, boolean verbose) {
        this.fInstance = testClassInstance;
        this.fGenerator = generator;
        this.fMethod = method;
        this.fSetupMethod = CharacteristicsTester.getMethod(testClassInstance, "setUp");
        this.fTearDownMethod = CharacteristicsTester.getMethod(testClassInstance, "tearDown");
        this.fRuns = runs;
        this.fVerbose = verbose;
    }

    public int countTestCases() {
        return 1;
    }

    public void runTest() {
        new RunnerFactory().createRunner(this.fGenerator, this.fRuns, this.characteristic(), this.fVerbose).forAll();
    }

    private Characteristic<Object> characteristic() {
        return new Characteristic<Object>(){

            @Override
            public void setUp() throws Exception {
                if (CharacteristicsTester.this.fSetupMethod != null) {
                    CharacteristicsTester.this.fSetupMethod.invoke(CharacteristicsTester.this.fInstance, new Object[0]);
                }
            }

            @Override
            public void specify(Object instance) throws Throwable {
                try {
                    CharacteristicsTester.this.fMethod.invoke(CharacteristicsTester.this.fInstance, instance);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }

            @Override
            public void tearDown() throws Exception {
                if (CharacteristicsTester.this.fTearDownMethod != null) {
                    CharacteristicsTester.this.fTearDownMethod.invoke(CharacteristicsTester.this.fInstance, new Object[0]);
                }
            }

            @Override
            public String name() {
                return this.getClass().getName();
            }
        };
    }

    public String getName() {
        return String.format("%s.%s[%s]", this.fInstance.getClass().getName(), this.fMethod.getName(), this.fGenerator.getClass().getName());
    }

    private static Method getMethod(Object newInstance, String methodName) {
        try {
            return newInstance.getClass().getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

