/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.junit4;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import junit.framework.AssertionFailedError;
import net.java.quickcheck.junit.support.Discovery;
import net.java.quickcheck.junit4.QuickCheckMethodRoadie;
import net.java.quickcheck.junit4.QuickCheckTestMethod;
import org.junit.internal.runners.InitializationError;
import org.junit.internal.runners.JUnit4ClassRunner;
import org.junit.internal.runners.TestClass;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

class OnlyQuickCheckRunner
extends JUnit4ClassRunner {
    private final List<Method> testMethods;
    private final TestClass testClass;

    public OnlyQuickCheckRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
        this.testClass = new TestClass(clazz);
        this.testMethods = Discovery.getCharacteristicMethods(clazz);
    }

    protected void validate() throws InitializationError {
    }

    public Description getDescription() {
        Description spec = Description.createSuiteDescription((String)this.getTestClass().getName(), (Annotation[])this.testClass.getJavaClass().getAnnotations());
        for (Method method : this.testMethods) {
            spec.addChild(this.methodDescription(method));
        }
        return spec;
    }

    protected void runMethods(RunNotifier notifier) {
        for (Method method : this.testMethods) {
            this.invokeTestMethod(method, notifier);
        }
    }

    protected void invokeTestMethod(Method method, RunNotifier notifier) {
        Description description = this.methodDescription(method);
        try {
            Object test = this.createTest();
            QuickCheckTestMethod testMethod = this.wrapMethod(method);
            new QuickCheckMethodRoadie(test, testMethod, notifier, description).run();
        }
        catch (AssertionFailedError e) {
            this.failure(notifier, description, e);
        }
        catch (InvocationTargetException e) {
            this.failure(notifier, description, e.getCause());
        }
        catch (Exception e) {
            this.failure(notifier, description, e);
        }
    }

    private void failure(RunNotifier notifier, Description description, Throwable cause) {
        notifier.fireTestFailure(new Failure(description, cause));
    }

    protected QuickCheckTestMethod wrapMethod(Method method) {
        return new QuickCheckTestMethod(method, this.testClass);
    }
}

