/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.junit4;

import java.lang.reflect.InvocationTargetException;
import junit.framework.Assert;
import net.java.quickcheck.Characteristic;
import net.java.quickcheck.Generator;
import net.java.quickcheck.Runner;
import net.java.quickcheck.RunnerFactory;
import net.java.quickcheck.characteristic.Classification;
import net.java.quickcheck.characteristic.ClassificationExpectation;
import net.java.quickcheck.generator.support.RoundRobinGenerator;
import net.java.quickcheck.junit.ForAll;
import net.java.quickcheck.junit.support.GeneratorFactory;
import net.java.quickcheck.junit4.QuickCheckTestMethod;
import org.junit.internal.runners.MethodRoadie;
import org.junit.internal.runners.TestMethod;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;

class QuickCheckMethodRoadie
extends MethodRoadie {
    private final Generator<Object> generator;
    private final Object test;
    private final QuickCheckTestMethod method;
    private final ForAll annotation;

    public QuickCheckMethodRoadie(Object test, QuickCheckTestMethod method, RunNotifier notifier, Description description) {
        super(test, (TestMethod)method, notifier, description);
        ForAll annotation;
        this.annotation = annotation = method.getMethod().getAnnotation(ForAll.class);
        this.generator = new RoundRobinGenerator<Object>(GeneratorFactory.createGenerator(test, annotation));
        this.test = test;
        this.method = method;
    }

    public void runTest() {
        this.clearExpectations();
        try {
            RunnerCharacteristic runnerCharacteristic = new RunnerCharacteristic();
            Runner<Object> runner = new RunnerFactory().createRunner(this.generator, this.annotation.runs(), runnerCharacteristic, this.annotation.verbose());
            runner.forAll();
            ClassificationExpectation expectation = ClassificationExpectation.gathered();
            if (expectation != null) {
                Classification classification = Classification.gathered();
                Assert.assertEquals((String)String.format("expected %s but was %s", expectation, classification), (boolean)true, (boolean)expectation.validate(classification));
            }
        }
        finally {
            this.clearExpectations();
        }
    }

    private void clearExpectations() {
        ClassificationExpectation.clear();
        Classification.clear();
    }

    private final class RunnerCharacteristic
    implements Characteristic<Object> {
        private RunnerCharacteristic() {
        }

        @Override
        public void specify(Object any) throws Throwable {
            TestRunnable testRunnable = new TestRunnable(any);
            QuickCheckMethodRoadie.this.runBeforesThenTestThenAfters(testRunnable);
            if (testRunnable.isStopped()) {
                throw testRunnable.getCause();
            }
            Classification.callDone();
        }

        @Override
        public String name() {
            return QuickCheckMethodRoadie.this.method.getMethod().getName();
        }

        @Override
        public void setUp() throws Exception {
        }

        @Override
        public void tearDown() throws Exception {
        }
    }

    private final class TestRunnable
    implements Runnable {
        private final Object any;
        private boolean stop = false;
        private Throwable cause;

        private TestRunnable(Object any) {
            this.any = any;
        }

        @Override
        public void run() {
            try {
                QuickCheckMethodRoadie.this.method.getMethod().invoke(QuickCheckMethodRoadie.this.test, this.any);
            }
            catch (InvocationTargetException e) {
                this.stopNow(e.getCause());
            }
            catch (Exception e) {
                this.stopNow(e);
            }
        }

        private void stopNow(Throwable e) {
            this.stop = true;
            this.cause = e;
        }

        public boolean isStopped() {
            return this.stop;
        }

        public Throwable getCause() {
            return this.cause;
        }
    }
}

