/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.util;

import java.util.Collection;

public final class Assert {
    private static final String MISSING = "MISSING";

    private Assert() {
    }

    public static void notNull(Object arg, String argName) {
        if (arg == null) {
            throw new IllegalArgumentException("Argument " + Assert.caption(argName) + " expected to be not null");
        }
    }

    public static void notEmpty(char[] arg, String argName) {
        if (arg.length == 0) {
            throw new IllegalArgumentException("Array " + Assert.caption(argName) + " expected to be not empty");
        }
    }

    public static void notEmpty(Object[] arg, String argName) {
        if (arg.length == 0) {
            throw new IllegalArgumentException("Array " + Assert.caption(argName) + " expected to be not empty");
        }
    }

    public static <T> void notEmpty(Collection<T> arg, String argName) {
        if (arg.isEmpty()) {
            throw new IllegalArgumentException("Collection " + Assert.caption(argName) + " expected to be not empty");
        }
    }

    public static void lessOrEqual(double threshold, double arg, String argName) {
        if (arg > threshold) {
            throw new IllegalArgumentException("Value " + Assert.value(arg) + " of argument " + Assert.caption(argName) + " expected to be not greater than " + Assert.value(threshold));
        }
    }

    public static void equal(double expected, double arg, String argName) {
        if (arg != expected) {
            throw new IllegalArgumentException(String.format("Value %s of argument %s expected to be not equal to %s", Assert.value(arg), Assert.caption(argName), Assert.value(expected)));
        }
    }

    public static void greaterOrEqual(double threshold, double arg, String argName) {
        if (arg < threshold) {
            throw new IllegalArgumentException("Value " + Assert.value(arg) + " of argument " + Assert.caption(argName) + " expected to be not less than " + Assert.value(threshold));
        }
    }

    private static String caption(Object obj) {
        return "[" + (obj == null ? MISSING : obj) + "]";
    }

    private static String value(Object value) {
        return "<" + (value == null ? MISSING : value) + ">";
    }
}

