/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.jmx;

import java.util.Date;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.StandardMBean;
import net.java.truecommons.cio.Entry;
import net.java.truecommons.cio.IoBuffer;
import net.java.truevfs.comp.jmx.JmxBufferMXBean;

@ThreadSafe
public class JmxBufferView<B extends IoBuffer>
extends StandardMBean
implements JmxBufferMXBean {
    protected final B buffer;

    public JmxBufferView(B buffer) {
        this(buffer, JmxBufferMXBean.class);
    }

    protected JmxBufferView(B buffer, Class<? extends JmxBufferMXBean> type) {
        super(type, true);
        this.buffer = (IoBuffer)Objects.requireNonNull(buffer);
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        return "An I/O buffer.";
    }

    @Override
    protected String getDescription(MBeanAttributeInfo info) {
        switch (info.getName()) {
            case "Name": {
                return "The name of this buffer.";
            }
            case "SizeOfData": {
                return "The data size of this buffer.";
            }
            case "SizeOfStorage": {
                return "The storage size of this buffer.";
            }
            case "TimeCreatedDate": {
                return "The time this buffer has been created.";
            }
            case "TimeCreatedMillis": {
                return "The time this buffer has been created in milliseconds.";
            }
            case "TimeReadDate": {
                return "The last time this buffer has been read or accessed.";
            }
            case "TimeReadMillis": {
                return "The last time this buffer has been read or accessed in milliseconds.";
            }
            case "TimeWrittenDate": {
                return "The last time this buffer has been written.";
            }
            case "TimeWrittenMillis": {
                return "The last time this buffer has been written in milliseconds.";
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return this.buffer.getName();
    }

    @Override
    public long getSizeOfData() {
        return this.buffer.getSize(Entry.Size.DATA);
    }

    @Override
    public long getSizeOfStorage() {
        return this.buffer.getSize(Entry.Size.STORAGE);
    }

    @Override
    public String getTimeCreatedDate() {
        long time = this.buffer.getTime(Entry.Access.CREATE);
        return -1L == time ? null : new Date(time).toString();
    }

    @Override
    public Long getTimeCreatedMillis() {
        long time = this.buffer.getTime(Entry.Access.CREATE);
        return -1L == time ? null : Long.valueOf(time);
    }

    @Override
    public String getTimeReadDate() {
        long time = this.buffer.getTime(Entry.Access.READ);
        return -1L == time ? null : new Date(time).toString();
    }

    @Override
    public Long getTimeReadMillis() {
        long time = this.buffer.getTime(Entry.Access.READ);
        return -1L == time ? null : Long.valueOf(time);
    }

    @Override
    public String getTimeWrittenDate() {
        long time = this.buffer.getTime(Entry.Access.WRITE);
        return -1L == time ? null : new Date(time).toString();
    }

    @Override
    public Long getTimeWrittenMillis() {
        long time = this.buffer.getTime(Entry.Access.WRITE);
        return -1L == time ? null : Long.valueOf(time);
    }
}

